#version 150

uniform vec4 color;

uniform sampler2D hatchings;
uniform float hatchingFactor;
uniform float fadingFactor;

// -- input
in float v_fill;
in vec2 v_texCoord0;

// --- output ---
out vec4 o_out;
void main() {

    float mask = mix(1.0, texture(hatchings, v_texCoord0).r, hatchingFactor);
    o_out = vec4(color*mask) * mix( smoothstep(0.0, 0.01, v_fill), v_fill, fadingFactor);

}