#version 150

in vec2 position;
in vec2 texCoord0;
uniform mat4 modelViewProjectionMatrix;
uniform samplerBuffer positions;

out vec2 v_texCoord0;
uniform vec2[256] controlPoints;
uniform int paths;

uniform bool pathClosed;

void main() {
    vec4 data = texelFetch(positions, gl_InstanceID);

    float segmentLength = data.z;
    float segmentOffset = data.y;
    float segmentWeight = data.w;

    float t = data.x + position.x * segmentLength;
    vec2 nposition = position;

    t = pathClosed? mod(t, paths) : clamp(t, 0, paths-0.000001);

    int path = int(floor(t));// % 8;
    int pathIndex = path * 4;

    t -= path;
    t = clamp(t, 0, 1);


    float it = 1.0-t;
    float it2 = it * it;
    float it3 = it2 * it;
    float t2 = t * t;
    float t3 = t2 * t;

    vec2 origin = it3 * controlPoints[0 + pathIndex] +
                  3.0 * it2 * t * controlPoints[1 + pathIndex] +
                  3.0 * it * t2 * controlPoints[2 + pathIndex] +
                  t3 * controlPoints[3 + pathIndex];

    vec2 tangent = normalize(
        3.0 * it2 * (controlPoints[1 + pathIndex] - controlPoints[0 + pathIndex]) +
        6.0 * it * t * (controlPoints[2 + pathIndex] - controlPoints[1 + pathIndex]) +
        3.0 * t2 * (controlPoints[3 + pathIndex] - controlPoints[2 + pathIndex])
        );

    vec2 normal = normalize(vec2(tangent.y, -tangent.x));

    mat2 tn = mat2(tangent, normal);

    vec2 transformed = origin + tn * (nposition.xy * vec2(1, segmentWeight)) + normal * segmentOffset;

    // -- output --
    v_texCoord0 = texCoord0;
    gl_Position = modelViewProjectionMatrix * vec4(transformed, 0, 1);
}