#version 330

uniform mat4 modelViewProjectionMatrix;
uniform mat4 normalMatrix;
uniform mat4 modelViewMatrix;

in vec3 position;
in vec3 normal;

out vec3 v_normal;
out vec3 v_position;

void main(void) {
    gl_Position = modelViewProjectionMatrix * vec4(position, 1.0);
    v_position = (modelViewMatrix * vec4(position, 1.0)).xyz;
    v_normal = normalize(( normalMatrix * vec4(normal, 1.0)).xyz);
}