#version 150

in vec2 v_texCoord0;


out vec4 o_color;

uniform sampler2D colors;
uniform sampler2D positions;
uniform sampler2D noise;

uniform vec2 blurDirection;

void main() {

    float depth = texture(positions, v_texCoord0).z;

    int window = max(0, min(4, int( ((-depth-0.3)/0.2 ) + texture(noise, v_texCoord0).x*0.5)  ));

    vec4 sum = vec4(0.0);
    float weight = 0.0;
    for (int i = -window; i <= window; ++i) {

        float sampleDepth = texture(positions, v_texCoord0).z;

        if (sampleDepth-depth >= -0.1) {

            float ni = i / float(window);
            float w = exp(-(ni*ni)*3);

            sum+=texture(colors, v_texCoord0 + i * blurDirection) * w;
            weight += w;
        }
    }

    o_color = sum / weight;

    o_color = pow(o_color, vec4(1.4));
    //o_color.b += 0.1 * v_texCoord0.y;

}