#version 150

in vec2 v_texCoord0;
uniform sampler2D image;
uniform vec2 blurDirection;

out vec4  o_color;
void main() {

    vec2 s = textureSize(image, 0).xy;
    s.x = 1.0 / s.x;
    s.y = 1.0 / s.y;
    vec4 sum = vec4(0,0,0,0);

    int w = 32;

    float weight;


    int ix = int(v_texCoord0.x * 1280);
    int iy = int(v_texCoord0.y * 720);

    if (ix > 426 && ix < 1280-426 && iy > 147 && iy < 720-147) {
            for (int x = -w; x<= w; ++x) {
                float lw = exp(-(x*x)*0.01);
                sum+=texture(image, v_texCoord0 + x * blurDirection) * lw;
                weight+=lw;
        }
    }
    else {
        sum = texture(image, v_texCoord0);
        weight = 1;

    }
    o_color = sum / weight;
    o_color.a = 1;

}