/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.sndr;

import net.lustlab.sndr.JOALUtil;
import net.lustlab.sndr.Vector;

public class SoundListener
extends Vector {
    protected JOALUtil liboal;
    protected float[] pos = new float[]{0.0f, 0.0f, 0.0f};
    protected float[] vel = new float[]{0.0f, 0.0f, 0.0f};
    protected float[] orient = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f};

    protected SoundListener(JOALUtil lib) {
        this.liboal = lib;
        this.setGain(1.0f);
        this.setPosition(this.pos);
        this.setVelocity(this.vel);
    }

    public void setGain(float gain) {
        this.liboal.getAL().alListenerf(4106, gain);
    }

    public void updatePosition() {
        this.pos[0] = this.x;
        this.pos[1] = this.y;
        this.pos[2] = this.z;
        this.liboal.getAL().alListenerfv(4100, this.pos, 0);
    }

    public void setPosition(float xx, float yy, float zz) {
        this.pos[0] = xx;
        this.pos[1] = yy;
        this.pos[2] = zz;
        this.setPosition(this.pos);
    }

    public final void setPosition(float[] pos) {
        this.x = pos[0];
        this.y = pos[1];
        this.z = pos[2];
        this.liboal.getAL().alListenerfv(4100, pos, 0);
    }

    public float[] getPosition() {
        return this.pos;
    }

    public void setVelocity(float xx, float yy, float zz) {
        this.vel[0] = xx;
        this.vel[1] = yy;
        this.vel[2] = zz;
        this.setVelocity(this.vel);
    }

    public final void setVelocity(float[] vel) {
        this.liboal.getAL().alListenerfv(4102, vel, 0);
    }

    public float[] getVelocity() {
        return this.vel;
    }

    public void setOrientation(float forwardX, float forwardY, float forwardZ, float upX, float upY, float upZ) {
        this.orient[0] = forwardX;
        this.orient[1] = forwardY;
        this.orient[2] = forwardZ;
        this.orient[3] = upX;
        this.orient[4] = upY;
        this.orient[5] = upZ;
        this.setOrientation(this.orient);
    }

    public final void setOrientation(float[] o) {
        if (o.length == 6) {
            this.orient = o;
            this.liboal.getAL().alListenerfv(4111, this.vel, 0);
        }
    }

    public float[] getOrientation() {
        return this.orient;
    }
}

