/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.sndr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.lustlab.sndr.AudioBuffer;
import net.lustlab.sndr.AudioSource;
import net.lustlab.sndr.JOALUtil;

public class Player {
    private JOALUtil audioSys;
    private ArrayList<AudioSource> sounds = new ArrayList();
    Map<String, AudioSource> sources = new HashMap<String, AudioSource>();
    Map<String, AudioBuffer> buffers = new HashMap<String, AudioBuffer>();

    public Player() {
        this.audioSys = JOALUtil.getInstance();
        this.audioSys.init();
    }

    public AudioSource getSource(int i) {
        return this.sounds.get(i);
    }

    public AudioSource playBlip(String filename, boolean loop, float pitch) {
        AudioBuffer buf = this.buffers.get(filename);
        AudioSource src = this.sources.get(filename);
        if (buf == null) {
            buf = this.audioSys.loadBuffer(filename);
            this.buffers.put(filename, buf);
        }
        if (src == null) {
            src = this.audioSys.generateSources(1)[0];
            src.setBuffer(buf);
            this.sources.put(filename, src);
        }
        src.setPitch(pitch);
        src.setGain(1.0f);
        src.play();
        return src;
    }

    public AudioSource playSound(String filename, boolean loop, float pitch) {
        AudioBuffer buf = this.audioSys.loadBuffer(filename);
        AudioSource src = this.audioSys.generateSources(1)[0];
        src.setBuffer(buf);
        src.setLooping(loop);
        src.setPitch(pitch);
        src.setGain(0.0f);
        src.play();
        this.sounds.add(src);
        return src;
    }
}

