/*
 * Decompiled with CFR 0.152.
 */
package thimble.sketches;

import framer.Animatable;
import framer.AnimationCompletedCallback;
import framer.Easing;
import javax.media.opengl.GL;
import net.lustlab.rndr.color.Color;
import net.lustlab.rndr.fbo.ColorBuffer;
import net.lustlab.rndr.fbo.DepthBuffer;
import net.lustlab.rndr.fbo.RenderTarget;
import net.lustlab.rndr.math.Linear;
import net.lustlab.rndr.math.Matrix44;
import net.lustlab.rndr.math.Transforms;
import net.lustlab.rndr.math.Vector3;
import net.lustlab.rndr.sketch.SketchGL3;
import thimble.effects.Grids;
import thimble.effects.RadialGradient;
import thimble.post.Cutter;

public class RadialGradientSketch
extends SketchGL3 {
    RadialGradient radialGradient;
    Cutter cutter;
    RenderTarget renderTarget;
    ColorBuffer colorBuffer;
    DepthBuffer depthBuffer;
    Grids grids;
    State state = new State();

    RadialGradientSketch() {
        this.configuration.width = 1280;
        this.configuration.height = 720;
    }

    public static String index(String name, int index) {
        return name + "[" + index + "]";
    }

    public void setup() {
        this.renderTarget = RenderTarget.create((GL)this.gl3, (int)this.width, (int)this.height);
        this.colorBuffer = ColorBuffer.create((GL)this.gl3, (int)this.width, (int)this.height);
        this.depthBuffer = DepthBuffer.create((GL)this.gl3, (int)this.width, (int)this.height);
        this.renderTarget.attach(this.colorBuffer).attach(this.depthBuffer).unbindTarget();
        this.cutter = new Cutter(this.gl3, this.width, this.height);
        this.radialGradient = new RadialGradient(this.gl3);
        this.grids = new Grids(this.gl3, this.width, this.height);
        this.state.updateAnimation();
        this.state.animate("x", 0.0, 0L).complete(new AnimationCompletedCallback(){

            public void animationCompleted(Animatable animatable) {
                RadialGradientSketch.this.state.animate("scale", Math.random() * 2.0 + 1.5, 1000L, Easing.CubicInOut);
                RadialGradientSketch.this.state.animate(RadialGradientSketch.index("opacity", RadialGradientSketch.this.state.index), 1.0, 500L, Easing.CubicInOut);
                RadialGradientSketch.this.state.add("rotation", Math.random() - 0.5, 1000L, Easing.CubicInOut);
                RadialGradientSketch.this.state.animate("x", 340.0 * (Math.random() - 0.5) + RadialGradientSketch.this.grids.hotX * (double)RadialGradientSketch.this.width - (double)(RadialGradientSketch.this.width / 2), 1500L, Easing.CubicInOut);
                RadialGradientSketch.this.state.animate("y", 340.0 * (Math.random() - 0.5) + RadialGradientSketch.this.grids.hotY * (double)RadialGradientSketch.this.height - (double)(RadialGradientSketch.this.height / 2), 1500L, Easing.CubicInOut);
                RadialGradientSketch.this.state.animate(RadialGradientSketch.index("radius", RadialGradientSketch.this.state.index), 240.0, 500L, Easing.CubicInOut).delay(1000L).animate(RadialGradientSketch.index("radius", RadialGradientSketch.this.state.index), 0.0, 2500L, Easing.CubicInOut).delay(1000L).animate(RadialGradientSketch.index("opacity", RadialGradientSketch.this.state.index), 0.0, 1000L, Easing.CubicInOut).add("x", 0.0, 0L).complete((AnimationCompletedCallback)this);
                RadialGradientSketch.this.state.gx[RadialGradientSketch.this.state.index] = RadialGradientSketch.this.grids.hotX * (double)RadialGradientSketch.this.width;
                RadialGradientSketch.this.state.gy[RadialGradientSketch.this.state.index] = RadialGradientSketch.this.grids.hotY * (double)RadialGradientSketch.this.height;
                RadialGradientSketch.this.state.index = (RadialGradientSketch.this.state.index + 1) % 2;
            }
        });
    }

    public void draw() {
        this.state.updateAnimation();
        this.background(Color.WHITE);
        Matrix44 ortho = Transforms.ortho((double)0.0, (double)this.width, (double)this.height, (double)0.0, (double)-1.0, (double)1.0);
        Matrix44 view = Matrix44.Identity;
        this.renderTarget.bindTarget();
        this.background(new Color(0.8196078431372549, 0.8666666666666667, 0.8666666666666667, 1.0));
        view = Linear.multiply((Matrix44[])new Matrix44[]{Transforms.translate((Vector3)new Vector3((double)(this.width / 2), (double)(this.height / 2), 0.0)), Transforms.scale((double)this.state.scale), Transforms.rotateZ((double)(0.7853981633974483 + this.state.rotation)), Transforms.translate((Vector3)new Vector3((double)(-this.width / 2), (double)(-this.height / 2), 0.0)), Transforms.translate((Vector3)new Vector3(-this.state.x, -this.state.y, 0.0))});
        for (int i = 0; i < 2; ++i) {
        }
        this.renderTarget.unbindTarget();
    }

    public static void main(String[] args) {
        SketchGL3.run((SketchGL3)new RadialGradientSketch());
    }

    public static class State
    extends Animatable {
        double x;
        double y;
        double[] gx = new double[2];
        double[] gy = new double[2];
        double[] radius = new double[2];
        double[] opacity = new double[2];
        double rotation;
        double scale;
        int index = 0;
    }
}

