/*
 * Decompiled with CFR 0.152.
 */
package thimble.post;

import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GL3;
import net.lustlab.rndr.color.Color;
import net.lustlab.rndr.image.Image;
import net.lustlab.rndr.math.Matrix44;
import net.lustlab.rndr.math.Vector2;
import net.lustlab.rndr.math.Vector3;
import net.lustlab.rndr.shaders.FragmentShader;
import net.lustlab.rndr.shaders.Shader;
import net.lustlab.rndr.shaders.VertexShader;
import net.lustlab.rndr.vbo.BufferWriter;
import net.lustlab.rndr.vbo.VBO;
import net.lustlab.rndr.vbo.VBODrawer;
import net.lustlab.rndr.vbo.VBOLayout;

public class Noise {
    VBO quad;
    VBOLayout layout;
    Shader shader;
    GL3 gl3;
    Image noise;

    public Noise(GL3 gl3, int width, int height) {
        double w = width;
        double h = height;
        this.layout = new VBOLayout().textureCoordinate(2).position(3);
        this.noise = Image.drawable((GL)gl3, (int)width, (int)height);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                this.noise.write(x, y, new Color(Math.random(), Math.random(), Math.random(), Math.random()));
            }
        }
        this.noise.upload();
        this.noise.texture.bind((GL)gl3);
        gl3.glGenerateMipmap(3553);
        gl3.glBindTexture(3553, 0);
        this.shader = Shader.createShader((GL)gl3, (VertexShader)VertexShader.load((GL)gl3, (InputStream)this.getClass().getResourceAsStream("/shaders/noise/noise.vert")), (FragmentShader)FragmentShader.load((GL)gl3, (InputStream)this.getClass().getResourceAsStream("/shaders/noise/noise.frag")));
        ByteBuffer bb = ByteBuffer.allocateDirect(6 * this.layout.size());
        BufferWriter bw = new BufferWriter(bb);
        Vector3 p00 = new Vector3(0.0, 0.0, 0.0);
        Vector3 p10 = new Vector3(w, 0.0, 0.0);
        Vector3 p11 = new Vector3(w, h, 0.0);
        Vector3 p01 = new Vector3(0.0, h, 0.0);
        Vector2 t00 = new Vector2(0.0, 0.0);
        Vector2 t10 = new Vector2(1.0, 0.0);
        Vector2 t11 = new Vector2(1.0, 1.0);
        Vector2 t01 = new Vector2(0.0, 1.0);
        bw.write(t11).write(p11).write(t10).write(p10).write(t00).write(p00);
        bw.write(t00).write(p00).write(t01).write(p01).write(t11).write(p11);
        bb.rewind();
        this.quad = VBO.createStaticVBO((GL)gl3, (ByteBuffer)bb, (long)bb.remaining());
        this.gl3 = gl3;
    }

    public void draw(Matrix44 projection, double intensity) {
        this.gl3.glEnable(3042);
        this.gl3.glBlendFunc(770, 771);
        this.noise.texture.bind((GL)this.gl3);
        this.gl3.glTexParameteri(3553, 10242, 10497);
        this.gl3.glTexParameteri(3553, 10243, 10497);
        this.quad.bind();
        this.shader.begin();
        this.shader.setUniform("offset", new Vector2(Math.random(), Math.random()));
        this.shader.setUniform("modelViewProjectionMatrix", projection.transpose());
        VBODrawer.draw((GL)this.gl3, (Shader)this.shader, (VBO)this.quad, (VBOLayout)this.layout, (int)4, (int)6);
        this.shader.end();
        this.quad.unbind();
        this.gl3.glBindTexture(3553, 0);
        this.gl3.glDisable(3042);
    }
}

