/*
 * Decompiled with CFR 0.152.
 */
package thimble.post;

import framer.Animatable;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GL3;
import net.lustlab.rndr.fbo.ColorBuffer;
import net.lustlab.rndr.math.Matrix44;
import net.lustlab.rndr.math.Vector2;
import net.lustlab.rndr.math.Vector3;
import net.lustlab.rndr.noise.PerlinNoise;
import net.lustlab.rndr.shaders.FragmentShader;
import net.lustlab.rndr.shaders.Shader;
import net.lustlab.rndr.shaders.VertexShader;
import net.lustlab.rndr.vbo.BufferWriter;
import net.lustlab.rndr.vbo.VBO;
import net.lustlab.rndr.vbo.VBODrawer;
import net.lustlab.rndr.vbo.VBOLayout;

public class HandyZoom
extends Animatable {
    VBO quad;
    VBOLayout layout;
    Shader shader;
    GL3 gl3;
    PerlinNoise perlinNoise = new PerlinNoise();
    public double x = 0.0;
    public double y = 0.0;
    public double zoom = 0.24;
    double offsetx;
    double offsety;
    public double rotation = 0.0;
    public double tilex = 1.0;
    public double tiley = 1.0;
    public double pretilex = 1.0;
    public double pretiley = 1.0;

    public HandyZoom(GL3 gl3, int width, int height) {
        double w = width;
        double h = height;
        this.layout = new VBOLayout().textureCoordinate(2).position(3);
        this.shader = Shader.createShader((GL)gl3, (VertexShader)VertexShader.load((GL)gl3, (InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/shaders/handyzoom/handyzoom.vert")), (FragmentShader)FragmentShader.load((GL)gl3, (InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/shaders/handyzoom/handyzoom.frag")));
        ByteBuffer bb = ByteBuffer.allocateDirect(6 * this.layout.size());
        BufferWriter bw = new BufferWriter(bb);
        Vector3 p00 = new Vector3(0.0, 0.0, 0.0);
        Vector3 p10 = new Vector3(w, 0.0, 0.0);
        Vector3 p11 = new Vector3(w, h, 0.0);
        Vector3 p01 = new Vector3(0.0, h, 0.0);
        Vector2 t00 = new Vector2(0.0, 0.0);
        Vector2 t10 = new Vector2(1.0, 0.0);
        Vector2 t11 = new Vector2(1.0, 1.0);
        Vector2 t01 = new Vector2(0.0, 1.0);
        bw.write(t11).write(p11).write(t10).write(p10).write(t00).write(p00);
        bw.write(t00).write(p00).write(t01).write(p01).write(t11).write(p11);
        bb.rewind();
        this.quad = VBO.createStaticVBO((GL)gl3, (ByteBuffer)bb, (long)bb.remaining());
        this.gl3 = gl3;
    }

    public void draw(Matrix44 projection, ColorBuffer colors, double time) {
        this.updateAnimation();
        colors.bindTexture((GL)this.gl3);
        this.quad.bind();
        double[] noise = this.perlinNoise.dbrown(time * 0.04553, this.x + 1.0, this.y + 1.0, 8);
        double[] noise2 = this.perlinNoise.dbrown(time * 0.05233, this.y + 1.5434, this.x + 1.1323, 8);
        double[] noise3 = this.perlinNoise.dbrown(time * 0.019233, this.y + 1.5434, this.x + 1.1323, 8);
        double[] noise4 = this.perlinNoise.dbrown(time * 0.013633, this.y + 0.344, this.x + 0.4223, 8);
        this.shader.begin();
        this.shader.setUniform("projectionMatrix", projection.transpose());
        this.shader.setUniform("target", new Vector2(this.x, this.y));
        this.shader.setUniform1f("zoom", (float)(this.zoom + noise3[0] * 0.05));
        this.shader.setUniform1f("rotation", (float)this.rotation);
        this.shader.setUniform("tile", new Vector2(this.tilex, this.tiley));
        this.shader.setUniform("offset", new Vector2(this.offsetx, this.offsety));
        this.shader.setUniform("pretile", new Vector2(this.pretilex, this.pretiley));
        this.quad.bind();
        VBODrawer.draw((GL)this.gl3, (Shader)this.shader, (VBO)this.quad, (VBOLayout)this.layout, (int)4, (int)6);
        this.quad.unbind();
        this.shader.end();
        this.quad.unbind();
        this.gl3.glBindTexture(3553, 0);
    }
}

