/*
 * Decompiled with CFR 0.152.
 */
package thimble.post;

import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GL3;
import net.lustlab.rndr.fbo.ColorBuffer;
import net.lustlab.rndr.fbo.RenderTarget;
import net.lustlab.rndr.math.Matrix44;
import net.lustlab.rndr.math.Transforms;
import net.lustlab.rndr.math.Vector2;
import net.lustlab.rndr.math.Vector3;
import net.lustlab.rndr.shaders.FragmentShader;
import net.lustlab.rndr.shaders.Shader;
import net.lustlab.rndr.shaders.VertexShader;
import net.lustlab.rndr.vbo.BufferWriter;
import net.lustlab.rndr.vbo.VBO;
import net.lustlab.rndr.vbo.VBODrawer;
import net.lustlab.rndr.vbo.VBOLayout;

public class Blur {
    VBO quad;
    VBOLayout layout;
    Shader shader;
    GL3 gl3;
    int width;
    RenderTarget target;
    ColorBuffer colors;
    int height;

    public Blur(GL3 gl3, int width, int height) {
        this.width = width;
        this.height = height;
        double w = width;
        double h = height;
        this.layout = new VBOLayout().textureCoordinate(2).position(3);
        this.target = RenderTarget.create((GL)gl3, (int)width, (int)height);
        this.colors = ColorBuffer.create((GL)gl3, (int)width, (int)height);
        this.target.attach(this.colors).unbindTarget();
        this.shader = Shader.createShader((GL)gl3, (VertexShader)VertexShader.load((GL)gl3, (InputStream)this.getClass().getResourceAsStream("/shaders/blur/blur.vert")), (FragmentShader)FragmentShader.load((GL)gl3, (InputStream)this.getClass().getResourceAsStream("/shaders/blur/blur.frag")));
        ByteBuffer bb = ByteBuffer.allocateDirect(6 * this.layout.size());
        BufferWriter bw = new BufferWriter(bb);
        Vector3 p00 = new Vector3(0.0, 0.0, 0.0);
        Vector3 p10 = new Vector3(w, 0.0, 0.0);
        Vector3 p11 = new Vector3(w, h, 0.0);
        Vector3 p01 = new Vector3(0.0, h, 0.0);
        Vector2 t00 = new Vector2(0.0, 0.0);
        Vector2 t10 = new Vector2(1.0, 0.0);
        Vector2 t11 = new Vector2(1.0, 1.0);
        Vector2 t01 = new Vector2(0.0, 1.0);
        bw.write(t11).write(p11).write(t10).write(p10).write(t00).write(p00);
        bw.write(t00).write(p00).write(t01).write(p01).write(t11).write(p11);
        bb.rewind();
        this.quad = VBO.createStaticVBO((GL)gl3, (ByteBuffer)bb, (long)bb.remaining());
        this.gl3 = gl3;
    }

    public void draw(Matrix44 projection, ColorBuffer colors, double time) {
        colors.bindTexture((GL)this.gl3);
        this.quad.bind();
        this.shader.begin();
        this.target.bindTarget();
        this.gl3.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.gl3.glClear(16384);
        Matrix44 ortho = Transforms.ortho((double)0.0, (double)this.width, (double)this.height, (double)0.0, (double)-1.0, (double)1.0);
        this.shader.setUniform("blurDirection", new Vector2(1.0 / (double)colors.width, 0.0));
        this.shader.setUniform("modelViewProjectionMatrix", ortho.transpose());
        VBODrawer.draw((GL)this.gl3, (Shader)this.shader, (VBO)this.quad, (VBOLayout)this.layout, (int)4, (int)6);
        this.target.unbindTarget();
        this.colors.bindTexture((GL)this.gl3);
        this.shader.setUniform("blurDirection", new Vector2(0.0, 1.0 / (double)colors.height));
        this.shader.setUniform("modelViewProjectionMatrix", ortho.transpose());
        VBODrawer.draw((GL)this.gl3, (Shader)this.shader, (VBO)this.quad, (VBOLayout)this.layout, (int)4, (int)6);
        this.quad.unbind();
        this.shader.end();
        this.gl3.glBindTexture(3553, 0);
    }
}

