/*
 * Decompiled with CFR 0.152.
 */
package thimble.effects.ca;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.media.opengl.GL;
import javax.media.opengl.GL3;
import net.lustlab.rndr.color.Color;
import net.lustlab.rndr.image.BufferTexture;
import net.lustlab.rndr.image.Image;
import net.lustlab.rndr.math.Matrix44;
import net.lustlab.rndr.math.Vector2;
import net.lustlab.rndr.math.Vector4;
import net.lustlab.rndr.shaders.FragmentShader;
import net.lustlab.rndr.shaders.Shader;
import net.lustlab.rndr.shaders.VertexShader;
import net.lustlab.rndr.vbo.BufferWriter;
import net.lustlab.rndr.vbo.VBO;
import net.lustlab.rndr.vbo.VBODrawer;
import net.lustlab.rndr.vbo.VBOLayout;
import thimble.effects.ca.Grid;

public class GridDrawer {
    public boolean useHatchings = false;
    public boolean useSliding = false;
    public boolean useFading = false;
    public Color color = Color.WHITE;
    VBO vbo;
    VBOLayout layout;
    Shader shader;
    BufferTexture positions;
    GL3 gl3;
    ByteBuffer positionsBuffer;
    Image hatchings;

    public GridDrawer(GL3 gl3, int width, int height) {
        this.gl3 = gl3;
        this.hatchings = Image.loadFromFile((GL)gl3, (String)"data/images/hatchings.png");
        this.shader = Shader.createShader((GL)gl3, (VertexShader)VertexShader.load((GL)gl3, (InputStream)this.getClass().getResourceAsStream("/shaders/griddrawer/griddrawer.vert")), (FragmentShader)FragmentShader.load((GL)gl3, (InputStream)this.getClass().getResourceAsStream("/shaders/griddrawer/griddrawer.frag")));
        this.layout = new VBOLayout().color(4).textureCoordinate(2).position(2);
        ByteBuffer bb = ByteBuffer.allocateDirect(6 * this.layout.size());
        BufferWriter bw = new BufferWriter(bb);
        Vector2 uv00 = new Vector2(0.0, 1.0);
        Vector2 uv01 = new Vector2(0.0, 0.0);
        Vector2 uv11 = new Vector2(1.0, 0.0);
        Vector2 uv10 = new Vector2(1.0, 1.0);
        Vector2 p00 = new Vector2(-0.5, -0.5);
        Vector2 p01 = new Vector2(-0.5, 0.5);
        Vector2 p11 = new Vector2(0.5, 0.5);
        Vector2 p10 = new Vector2(0.5, -0.5);
        Vector4 f = new Vector4();
        bw.write(f).write(uv00).write(p00).write(f).write(uv01).write(p01).write(f).write(uv11).write(p11);
        bw.write(f).write(uv11).write(p11).write(f).write(uv10).write(p10).write(f).write(uv00).write(p00);
        this.positionsBuffer = ByteBuffer.allocateDirect(width * height * 4 * 4).order(ByteOrder.nativeOrder());
        this.positions = BufferTexture.createStream((GL3)gl3, (ByteBuffer)this.positionsBuffer, (int)(width * height * 4 * 4), (int)34836);
        bb.rewind();
        this.vbo = VBO.createStaticVBO((GL)gl3, (ByteBuffer)bb, (long)bb.remaining());
    }

    public void draw(Matrix44 projection, Matrix44 view, Grid grid, double intensity) {
        this.shader.begin();
        this.shader.setUniform("modelViewProjectionMatrix", projection.multiply(view).transpose());
        this.positionsBuffer.rewind();
        for (int y = 0; y < grid.height; ++y) {
            for (int x = 0; x < grid.width; ++x) {
                Grid.Cell cell = grid.cells[y][x];
                this.positionsBuffer.putFloat((float)cell.x).putFloat((float)cell.y).putFloat((float)cell.fill).putFloat(cell.dir);
            }
        }
        this.positionsBuffer.rewind();
        this.positions.write(this.gl3, this.positionsBuffer);
        this.gl3.glActiveTexture(33984);
        this.positions.bindTexture();
        this.gl3.glActiveTexture(33985);
        this.hatchings.texture.bind((GL)this.gl3);
        this.gl3.glActiveTexture(33984);
        this.shader.setUniform1i("positions", 0);
        this.shader.setUniform1i("hatchings", 1);
        Color cc = new Color(this.color.r, this.color.g, this.color.b, intensity);
        this.shader.setUniform("color", cc);
        if (this.useFading) {
            this.shader.setUniform1f("fadingFactor", 1.0f);
        } else {
            this.shader.setUniform1f("fadingFactor", 0.0f);
        }
        if (this.useSliding) {
            this.shader.setUniform1f("slidingFactor", 1.0f);
        } else {
            this.shader.setUniform1f("slidingFactor", 0.0f);
        }
        if (this.useHatchings) {
            this.shader.setUniform1f("hatchingFactor", 1.0f);
        } else {
            this.shader.setUniform1f("hatchingFactor", 0.0f);
        }
        this.vbo.bind();
        VBODrawer.drawInstances((GL)this.gl3, (Shader)this.shader, (VBO)this.vbo, (VBOLayout)this.layout, (int)4, (int)6, (int)(grid.width * grid.height));
        this.vbo.unbind();
        this.positions.unbindTexture();
        this.shader.end();
    }
}

