/*
 * Decompiled with CFR 0.152.
 */
package thimble.effects;

import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GL3;
import net.lustlab.rndr.color.Color;
import net.lustlab.rndr.image.Image;
import net.lustlab.rndr.math.Matrix44;
import net.lustlab.rndr.math.Vector2;
import net.lustlab.rndr.math.Vector4;
import net.lustlab.rndr.shaders.FragmentShader;
import net.lustlab.rndr.shaders.Shader;
import net.lustlab.rndr.shaders.VertexShader;
import net.lustlab.rndr.vbo.BufferWriter;
import net.lustlab.rndr.vbo.VBO;
import net.lustlab.rndr.vbo.VBODrawer;
import net.lustlab.rndr.vbo.VBOLayout;

public class RadialGradient {
    Shader shader;
    VBO quad;
    VBOLayout layout;
    Image image;
    GL3 gl3;

    public RadialGradient(GL3 gl3) {
        this.image = Image.drawable((GL)gl3, (int)256, (int)256);
        for (int y = 0; y < this.image.height; ++y) {
            for (int x = 0; x < this.image.width; ++x) {
                this.image.write(x, y, new Color(Math.random(), Math.random(), Math.random(), Math.random()));
            }
        }
        this.image.upload();
        this.gl3 = gl3;
        this.layout = new VBOLayout().textureCoordinate(2).position(2);
        ByteBuffer bb = ByteBuffer.allocateDirect(this.layout.size() * 6);
        Vector2 uv00 = new Vector2(0.0, 0.0);
        Vector2 uv10 = new Vector2(1.0, 0.0);
        Vector2 uv11 = new Vector2(1.0, 1.0);
        Vector2 uv01 = new Vector2(0.0, 1.0);
        Vector2 p00 = new Vector2(-1.0, -1.0);
        Vector2 p10 = new Vector2(1.0, -1.0);
        Vector2 p11 = new Vector2(1.0, 1.0);
        Vector2 p01 = new Vector2(-1.0, 1.0);
        BufferWriter bw = new BufferWriter(bb);
        bw.write(uv00).write(p00).write(uv01).write(p01).write(uv11).write(p11);
        bw.write(uv11).write(p11).write(uv10).write(p10).write(uv00).write(p00);
        bb.rewind();
        this.quad = VBO.createStaticVBO((GL)gl3, (ByteBuffer)bb, (long)bb.remaining());
        this.shader = Shader.createShader((GL)gl3, (VertexShader)VertexShader.load((GL)gl3, (InputStream)this.getClass().getResourceAsStream("/shaders/radialgradient/radialgradient.vert")), (FragmentShader)FragmentShader.load((GL)gl3, (InputStream)this.getClass().getResourceAsStream("/shaders/radialgradient/radialgradient.frag")));
    }

    public void draw(Matrix44 projection, Matrix44 modelView, double radius, double x, double y, Vector4[] gradient) {
        this.gl3.glEnable(3042);
        this.gl3.glBlendFunc(770, 771);
        this.shader.begin();
        this.image.texture.bind((GL)this.gl3);
        this.gl3.glTexParameteri(3553, 10242, 10497);
        this.gl3.glTexParameteri(3553, 10243, 10497);
        this.shader.setUniform("modelViewProjectionMatrix", projection.multiply(modelView).transpose());
        this.shader.setUniform1f("radius", (float)radius);
        this.shader.setUniform("colors", gradient);
        this.shader.setUniform("ds", new float[]{0.0f, 0.5f, 0.7f, 1.0f});
        this.shader.setUniform("offset", new Vector2(x, y));
        this.quad.bind();
        VBODrawer.draw((GL)this.gl3, (Shader)this.shader, (VBO)this.quad, (VBOLayout)this.layout, (int)4, (int)6);
        this.quad.unbind();
        this.gl3.glBindTexture(3553, 0);
        this.shader.end();
        this.gl3.glDisable(3042);
    }
}

