/*
 * Decompiled with CFR 0.152.
 */
package thimble.effects;

import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL3;
import net.lustlab.rndr.draw.Contour;
import net.lustlab.rndr.draw.Segment;
import net.lustlab.rndr.draw.Shape;
import net.lustlab.rndr.font.vector.FontVectorMap;
import net.lustlab.rndr.font.vector.FontVectorMapBuilder;
import net.lustlab.rndr.math.Matrix44;
import net.lustlab.rndr.math.Vector2;
import thimble.effects.Dazzle;
import thimble.effects.PathDazzleDrawer;

public class PathDazzler {
    PathDazzleDrawer drawer;
    GL3 gl3;
    List<List<Dazzle>> dazzles = new ArrayList<List<Dazzle>>();
    FontVectorMap vectorFont;
    int index = -1;
    String[] texts = new String[]{"Man, smell those trees!", "Smell those Douglas firs.", "What's down there?", "- An old logging road.", "The only access is five miles back at the Packard mill.", "I told Doc Hayward his daughter was OK.", "My fault, Harry."};

    public PathDazzler(GL3 gl3) {
        this.gl3 = gl3;
        this.drawer = new PathDazzleDrawer(gl3);
        this.vectorFont = FontVectorMapBuilder.buildFontMapFromFile((String)"data/fonts/bill-hair.ttf", (int)180);
        this.index = 0;
        this.initDazzles(this.index);
    }

    public void initDazzles(int index) {
        String text = this.texts[index % this.texts.length];
        this.dazzles.clear();
        int pointsPerSegment = 20;
        int idx = 0;
        ArrayList<Dazzle> dazzles = new ArrayList<Dazzle>();
        double rot = Math.random() * 0.03;
        double scale = Math.random() * 20.0 + 20.0;
        double speed = Math.random() * 3.0 + 1.0;
        double xrot = Math.random() * 0.03;
        double yrot = Math.random() * 0.03;
        this.drawer.patternFrequency = (double)((int)(6.0 + Math.random() * 2.0) * 2) * Math.PI;
        this.drawer.smoothing = 1.25 + Math.random() * Math.random() * 4.0;
        int line = 0;
        Vector2 cursor = new Vector2(200.0, 0.0);
        char[] arr$ = text.toCharArray();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            char c;
            char cl = c = arr$[i$];
            for (Shape shape : ((FontVectorMap.Entry)this.vectorFont.characters.get((Object)Character.valueOf((char)cl))).composition.shapes(".*")) {
                for (Contour contour : shape) {
                    for (Segment segment : contour) {
                        for (int i = 0; i < pointsPerSegment; ++i) {
                            Vector2 position = segment.position((double)i * (1.0 / (double)pointsPerSegment));
                            Dazzle dazzle = new Dazzle();
                            dazzle.x = position.x + 20.0 + cursor.x;
                            dazzle.y = position.y + cursor.y + 180.0;
                            dazzle.rotation = (double)idx * rot + position.x * xrot + position.y * yrot;
                            dazzle.scale = scale;
                            dazzle.add("rotation", Math.PI * 2 * speed, 10000L).complete();
                            dazzles.add(dazzle);
                            ++idx;
                        }
                    }
                }
            }
            cursor.x += ((FontVectorMap.Entry)this.vectorFont.characters.get((Object)Character.valueOf((char)cl))).width + scale / 2.0;
            if (!(cursor.x > 1080.0)) continue;
            cursor.x = 200 + 100 * ++line;
            cursor.y += 180.0;
        }
        this.dazzles.add(dazzles);
    }

    public void next() {
        ++this.index;
        this.initDazzles(this.index);
    }

    public void draw(Matrix44 projection, Matrix44 view, double time, double intensity) {
        this.gl3.glDisable(2929);
        for (List<Dazzle> dazzles : this.dazzles) {
            this.drawer.draw(projection, view, dazzles, intensity);
        }
    }
}

