/*
 * Decompiled with CFR 0.152.
 */
package thimble.effects;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.media.opengl.GL;
import javax.media.opengl.GL3;
import net.lustlab.rndr.fbo.ColorBuffer;
import net.lustlab.rndr.fbo.RenderTarget;
import net.lustlab.rndr.math.Matrix44;
import net.lustlab.rndr.math.Transforms;
import net.lustlab.rndr.math.Vector2;
import net.lustlab.rndr.math.Vector3;
import net.lustlab.rndr.shaders.FragmentShader;
import net.lustlab.rndr.shaders.Shader;
import net.lustlab.rndr.shaders.VertexShader;
import net.lustlab.rndr.vbo.BufferWriter;
import net.lustlab.rndr.vbo.VBO;
import net.lustlab.rndr.vbo.VBODrawer;
import net.lustlab.rndr.vbo.VBOLayout;

public class ParticleDynamics {
    RenderTarget[] positionsTargets;
    ColorBuffer[] positions;
    GL3 gl3;
    final int positionSize = 256;
    int frame;
    VBO updateQuad;
    VBO particle;
    VBOLayout updateLayout;
    VBOLayout particleLayout;
    Shader updateShader;
    Shader particleShader;

    public ParticleDynamics(GL3 gl3) {
        this.gl3 = gl3;
        this.particleLayout = new VBOLayout().textureCoordinate(2).position(3);
        this.positionsTargets = new RenderTarget[2];
        this.positions = new ColorBuffer[2];
        for (int i = 0; i < this.positions.length; ++i) {
            this.positions[i] = ColorBuffer.create((GL)gl3, (int)256, (int)256, (int)34836);
            this.positionsTargets[i] = RenderTarget.create((GL)gl3, (int)256, (int)256).attach(this.positions[i]).unbindTarget();
        }
        this.updateLayout = new VBOLayout().textureCoordinate(2).position(3);
        ByteBuffer buffer = ByteBuffer.allocateDirect(this.updateLayout.size() * 6);
        BufferWriter bw = new BufferWriter(buffer);
        double w = ((ColorBuffer)this.positionsTargets[0].colorBuffers.get((int)0)).width;
        double h = ((ColorBuffer)this.positionsTargets[0].colorBuffers.get((int)0)).height;
        Vector3 p00 = new Vector3(0.0, 0.0, 0.0);
        Vector3 p10 = new Vector3(w, 0.0, 0.0);
        Vector3 p11 = new Vector3(w, h, 0.0);
        Vector3 p01 = new Vector3(0.0, h, 0.0);
        Vector2 t00 = new Vector2(0.0, 0.0);
        Vector2 t10 = new Vector2(1.0, 0.0);
        Vector2 t11 = new Vector2(1.0, 1.0);
        Vector2 t01 = new Vector2(0.0, 1.0);
        bw.write(t00).write(p00).write(t10).write(p10).write(t11).write(p11);
        bw.write(t00).write(p00).write(t01).write(p01).write(t11).write(p11);
        buffer.rewind();
        this.updateQuad = VBO.createStaticVBO((GL)gl3, (ByteBuffer)buffer, (long)(this.updateLayout.size() * 6));
        this.updateShader = Shader.createShader((GL)gl3, (VertexShader)VertexShader.load((GL)gl3, (InputStream)this.getClass().getResourceAsStream("/shaders/particledynamics/update.vert")), (FragmentShader)FragmentShader.load((GL)gl3, (InputStream)this.getClass().getResourceAsStream("/shaders/particledynamics/update.frag")));
        buffer = ByteBuffer.allocateDirect(this.particleLayout.size() * 6);
        bw = new BufferWriter(buffer);
        w = 0.01;
        h = 0.01;
        p00 = new Vector3(-w, h, 0.0);
        p10 = new Vector3(w, h, 0.0);
        p11 = new Vector3(w, -h, 0.0);
        p01 = new Vector3(-w, -h, 0.0);
        t00 = new Vector2(0.0, 0.0);
        t10 = new Vector2(1.0, 0.0);
        t11 = new Vector2(1.0, 1.0);
        t01 = new Vector2(0.0, 1.0);
        bw.write(t00).write(p00).write(t10).write(p10).write(t11).write(p11);
        bw.write(t00).write(p00).write(t01).write(p01).write(t11).write(p11);
        buffer.rewind();
        this.particle = VBO.createStaticVBO((GL)gl3, (ByteBuffer)buffer, (long)(this.particleLayout.size() * 6));
        this.particleShader = Shader.createShader((GL)gl3, (VertexShader)VertexShader.load((GL)gl3, (InputStream)this.getClass().getResourceAsStream("/shaders/particledynamics/particle.vert")), (FragmentShader)FragmentShader.load((GL)gl3, (InputStream)this.getClass().getResourceAsStream("/shaders/particledynamics/particle.frag")));
    }

    public void draw(Matrix44 projection, Matrix44 modelView, double time) {
        int src = this.frame % 2;
        int dest = (this.frame + 1) % 2;
        int w = ((ColorBuffer)this.positionsTargets[0].colorBuffers.get((int)0)).width;
        int h = ((ColorBuffer)this.positionsTargets[0].colorBuffers.get((int)0)).height;
        this.gl3.glActiveTexture(33984);
        if (this.frame == 0) {
            int i;
            ByteBuffer bb = ByteBuffer.allocateDirect(w * h * 4 * 4);
            bb.order(ByteOrder.nativeOrder());
            for (i = 0; i < w * h * 4; ++i) {
                bb.putFloat((float)(Math.random() - 0.5));
            }
            bb.rewind();
            for (i = 0; i < this.positionsTargets.length; ++i) {
                this.positions[i].write((GL)this.gl3, bb, 5126);
            }
        }
        Matrix44 updateProjection = Transforms.ortho((double)0.0, (double)w, (double)0.0, (double)h, (double)-1.0, (double)1.0);
        this.positionsTargets[dest].bindTarget();
        this.positions[src].bindTexture((GL)this.gl3);
        this.gl3.glTexParameteri(3553, 10240, 9728);
        this.gl3.glTexParameteri(3553, 10241, 9728);
        this.updateShader.begin();
        this.updateShader.setUniform("projectionMatrix", updateProjection.transpose());
        this.updateShader.setUniform1f("time", (float)time);
        this.updateQuad.bind();
        VBODrawer.draw((GL)this.gl3, (Shader)this.updateShader, (VBO)this.updateQuad, (VBOLayout)this.updateLayout, (int)4, (int)6);
        this.updateQuad.unbind();
        this.updateShader.end();
        this.positionsTargets[dest].unbindTarget();
        this.gl3.glBindTexture(3553, 0);
        this.gl3.glDisable(2929);
        this.gl3.glEnable(3042);
        this.gl3.glBlendFunc(1, 1);
        this.positions[dest].bindTexture((GL)this.gl3);
        this.particleShader.begin();
        this.particleShader.setUniform("modelViewMatrix", modelView.transpose());
        this.particleShader.setUniform("projectionMatrix", projection.transpose());
        this.particle.bind();
        VBODrawer.drawInstances((GL)this.gl3, (Shader)this.particleShader, (VBO)this.particle, (VBOLayout)this.particleLayout, (int)4, (int)6, (int)(w * h));
        this.particle.unbind();
        this.particleShader.end();
        this.gl3.glBindTexture(3553, 0);
        this.gl3.glEnable(2929);
        this.gl3.glDisable(3042);
        ++this.frame;
    }
}

