/*
 * Decompiled with CFR 0.152.
 */
package thimble.effects;

import framer.Animatable;
import framer.Easing;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL;
import javax.media.opengl.GL3;
import net.lustlab.rndr.color.Color;
import net.lustlab.rndr.image.BufferTexture;
import net.lustlab.rndr.math.Linear;
import net.lustlab.rndr.math.Matrix44;
import net.lustlab.rndr.math.Transform;
import net.lustlab.rndr.math.Vector2;
import net.lustlab.rndr.math.Vector4;
import net.lustlab.rndr.shaders.FragmentShader;
import net.lustlab.rndr.shaders.Shader;
import net.lustlab.rndr.shaders.VertexShader;
import net.lustlab.rndr.vbo.BufferWriter;
import net.lustlab.rndr.vbo.VAO;
import net.lustlab.rndr.vbo.VBO;
import net.lustlab.rndr.vbo.VBODrawer;
import net.lustlab.rndr.vbo.VBOLayout;

public class GlyphScape {
    List<Glyph> glyphs = new ArrayList<Glyph>();
    private final ByteBuffer positionsBuffer;
    VBO quad;
    VAO quadVAO;
    BufferTexture positions;
    VBOLayout layout;
    Shader shader;
    int width;
    int height;
    double[] randoms;
    GL3 gl3;

    public GlyphScape(GL3 gl3, int width, int height) {
        this.gl3 = gl3;
        this.width = width;
        this.height = height;
        this.shader = Shader.createShader((GL)gl3, (VertexShader)VertexShader.load((GL)gl3, (InputStream)this.getClass().getResourceAsStream("/shaders/glyphscape/glyphscape.vert")), (FragmentShader)FragmentShader.load((GL)gl3, (InputStream)this.getClass().getResourceAsStream("/shaders/glyphscape/glyphscape.frag")));
        this.randoms = new double[height];
        for (int i = 0; i < this.randoms.length; ++i) {
            this.randoms[i] = Math.random();
        }
        this.layout = new VBOLayout().color(4).textureCoordinate(2).position(2);
        ByteBuffer bb = ByteBuffer.allocateDirect(6 * this.layout.size());
        BufferWriter bw = new BufferWriter(bb);
        Vector2 uv00 = new Vector2(0.0, 1.0);
        Vector2 uv01 = new Vector2(0.0, 0.0);
        Vector2 uv11 = new Vector2(1.0, 0.0);
        Vector2 uv10 = new Vector2(1.0, 1.0);
        Vector2 p00 = new Vector2(-0.5, -0.5);
        Vector2 p01 = new Vector2(-0.5, 0.5);
        Vector2 p11 = new Vector2(0.5, 0.5);
        Vector2 p10 = new Vector2(0.5, -0.5);
        Vector4 f = new Vector4();
        bw.write(f).write(uv00).write(p00).write(f).write(uv01).write(p01).write(f).write(uv11).write(p11);
        bw.write(f).write(uv11).write(p11).write(f).write(uv10).write(p10).write(f).write(uv00).write(p00);
        this.positionsBuffer = ByteBuffer.allocateDirect(width * height * 4 * 4).order(ByteOrder.nativeOrder());
        this.positions = BufferTexture.createStream((GL3)gl3, (ByteBuffer)this.positionsBuffer, (int)(width * height * 4 * 4), (int)34836);
        bb.rewind();
        this.quad = VBO.createStaticVBO((GL)gl3, (ByteBuffer)bb, (long)bb.remaining());
        this.quadVAO = VAO.createVAO((GL3)gl3, (VBO)this.quad, (VBOLayout)this.layout, (Shader)this.shader);
        this.quad.unbind();
        this.initGlyphs();
    }

    public void initGlyphs() {
        this.glyphs.clear();
        double y = 0.0;
        int j = 0;
        while (y < (double)this.height) {
            y += Math.random() * 20.0 + 6.0;
            int columns = 2 * (int)(this.randoms[j] * 20.0);
            int direction = (int)(Math.random() * 2.0);
            --direction;
            double height = 5.0;
            double width = 10.0 + Math.random() * 22.0;
            double spacing = 1.0 * (double)this.width / (double)(columns - 1);
            int duration = (int)(700.0 + Math.random() * 300.0);
            int delay = (int)(30.0 + Math.random() * 30.0);
            for (int i = 1; i < columns - 1; ++i) {
                int n;
                double x = (double)i * spacing;
                Glyph glyph = new Glyph();
                glyph.updateAnimation();
                glyph.x = x;
                glyph.y = y;
                glyph.width = width;
                glyph.height = height;
                glyph.delay(i * delay);
                if (direction == 0) {
                    for (n = 0; n < 300; ++n) {
                        glyph.delay(100L).add("x", spacing, (long)duration, Easing.CubicInOut).complete();
                    }
                }
                if (direction == -1) {
                    for (n = 0; n < 300; ++n) {
                        glyph.delay(100L).add("x", -spacing, (long)duration, Easing.CubicInOut).complete();
                    }
                }
                this.glyphs.add(glyph);
            }
            ++j;
        }
    }

    public void draw(Matrix44 projection) {
        BufferWriter bw = new BufferWriter(this.positionsBuffer);
        this.positionsBuffer.rewind();
        Transform t = new Transform().translate((double)(-this.width / 2), (double)(-this.height / 2)).rotateZ(0.7853981633974483).translate((double)(this.width / 2), (double)(this.height / 2));
        Transform t2 = new Transform().translate((double)(-this.width / 2), (double)(-this.height / 2)).rotateZ(-0.7853981633974483).translate((double)(this.width / 2), (double)(this.height / 2));
        for (Glyph glyph : this.glyphs) {
            glyph.updateAnimation();
            bw.write(new Vector4(this.mod(glyph.x, this.width), glyph.y, glyph.width, glyph.height));
        }
        this.positionsBuffer.rewind();
        this.positions.write(this.gl3, this.positionsBuffer);
        this.shader.begin();
        this.shader.setUniform("modelViewProjectionMatrix", Linear.multiply((Matrix44[])new Matrix44[]{projection, t.matrix}).transpose());
        this.shader.setUniform("fill", Color.BLACK);
        VBODrawer.drawInstances((GL)this.gl3, (VAO)this.quadVAO, (int)4, (int)6, (int)this.glyphs.size());
        this.shader.setUniform("modelViewProjectionMatrix", Linear.multiply((Matrix44[])new Matrix44[]{projection, t2.matrix}).transpose());
        VBODrawer.drawInstances((GL)this.gl3, (VAO)this.quadVAO, (int)4, (int)6, (int)this.glyphs.size());
        this.shader.end();
    }

    private double mod(double x, int width) {
        return (x % (double)width + (double)width) % (double)width;
    }

    static class Glyph
    extends Animatable {
        double x;
        double y;
        double width;
        double height;

        Glyph() {
        }
    }
}

