/*
 * Decompiled with CFR 0.152.
 */
package thimble.effects;

import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GL3;
import net.lustlab.rndr.math.Linear;
import net.lustlab.rndr.math.Matrix44;
import net.lustlab.rndr.math.Transforms;
import net.lustlab.rndr.math.Vector2;
import net.lustlab.rndr.math.Vector3;
import net.lustlab.rndr.shaders.FragmentShader;
import net.lustlab.rndr.shaders.Shader;
import net.lustlab.rndr.shaders.VertexShader;
import net.lustlab.rndr.vbo.BufferWriter;
import net.lustlab.rndr.vbo.VAO;
import net.lustlab.rndr.vbo.VBO;
import net.lustlab.rndr.vbo.VBODrawer;
import net.lustlab.rndr.vbo.VBOLayout;

public class Floor {
    VBO quad;
    VAO quadVAO;
    VBOLayout layout;
    GL3 gl3;
    Shader shader;

    public Floor(GL3 gl3) {
        this.gl3 = gl3;
        this.layout = new VBOLayout().textureCoordinate(2).normal(3).position(3);
        ByteBuffer buffer = ByteBuffer.allocateDirect(this.layout.size() * 6);
        BufferWriter bw = new BufferWriter(buffer);
        double w = 4.0;
        double d = 4.0;
        double h = -0.5;
        Vector3 n = new Vector3(0.0, 1.0, 0.0);
        Vector3 p00 = new Vector3(-w, h, d);
        Vector3 p10 = new Vector3(w, h, d);
        Vector3 p11 = new Vector3(w, h, -d);
        Vector3 p01 = new Vector3(-w, h, -d);
        Vector2 t00 = new Vector2(0.0, 0.0);
        Vector2 t10 = new Vector2(1.0, 0.0);
        Vector2 t11 = new Vector2(1.0, 1.0);
        Vector2 t01 = new Vector2(0.0, 1.0);
        bw.write(t00).write(n).write(p00).write(t10).write(n).write(p10).write(t11).write(n).write(p11);
        bw.write(t00).write(n).write(p11).write(t01).write(n).write(p01).write(t11).write(n).write(p00);
        buffer.rewind();
        this.quad = VBO.createStaticVBO((GL)gl3, (ByteBuffer)buffer, (long)(this.layout.size() * 6));
        this.shader = Shader.createShader((GL)gl3, (VertexShader)VertexShader.load((GL)gl3, (InputStream)this.getClass().getResourceAsStream("/shaders/floor/floor.vert")), (FragmentShader)FragmentShader.load((GL)gl3, (InputStream)this.getClass().getResourceAsStream("/shaders/floor/floor.frag")));
        this.quadVAO = VAO.createVAO((GL3)gl3, (VBO)this.quad, (VBOLayout)this.layout, (Shader)this.shader);
    }

    public void draw(Matrix44 projection, Matrix44 modelView, double time) {
        this.gl3.glDisable(2884);
        this.shader.begin();
        this.shader.setUniform("modelViewProjectionMatrix", Linear.multiply((Matrix44[])new Matrix44[]{projection, modelView}).transpose());
        this.shader.setUniform("modelViewMatrix", modelView.transpose());
        this.shader.setUniform("normalMatrix", Transforms.normal((Matrix44)modelView).transpose());
        this.quad.bind();
        VBODrawer.draw((GL3)this.gl3, (VAO)this.quadVAO, (int)4, (int)6);
        this.quad.unbind();
        this.shader.end();
    }
}

