/*
 * Decompiled with CFR 0.152.
 */
package thimble.effects;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL;
import javax.media.opengl.GL3;
import net.lustlab.rndr.draw.Contour;
import net.lustlab.rndr.draw.Segment;
import net.lustlab.rndr.image.BufferTexture;
import net.lustlab.rndr.math.Matrix44;
import net.lustlab.rndr.math.Vector2;
import net.lustlab.rndr.math.Vector4;
import net.lustlab.rndr.shaders.FragmentShader;
import net.lustlab.rndr.shaders.Shader;
import net.lustlab.rndr.shaders.VertexShader;
import net.lustlab.rndr.vbo.BufferWriter;
import net.lustlab.rndr.vbo.VAO;
import net.lustlab.rndr.vbo.VBO;
import net.lustlab.rndr.vbo.VBODrawer;
import net.lustlab.rndr.vbo.VBOLayout;
import thimble.effects.BezierSegments;

public class BezierSegmentsDrawer {
    private int segments = 24;
    private final ByteBuffer positionsBuffer;
    VBO quad;
    VAO quadVAO;
    BufferTexture[] positions;
    int index;
    VBOLayout layout;
    Shader shader;
    int width;
    int height;
    GL3 gl3;

    public BezierSegmentsDrawer(GL3 gl3, int width, int height) {
        this.gl3 = gl3;
        this.width = width;
        this.height = height;
        this.shader = Shader.createShader((GL)gl3, (VertexShader)VertexShader.load((GL)gl3, (InputStream)this.getClass().getResourceAsStream("/shaders/glyphscape/beziersegments.vert")), (FragmentShader)FragmentShader.load((GL)gl3, (InputStream)this.getClass().getResourceAsStream("/shaders/glyphscape/beziersegments.frag")));
        this.layout = new VBOLayout().color(4).textureCoordinate(2).position(2);
        ByteBuffer bb = ByteBuffer.allocateDirect(6 * this.segments * this.layout.size());
        BufferWriter bw = new BufferWriter(bb);
        for (int s = 0; s < this.segments; ++s) {
            double is = 1.0 / (double)this.segments;
            double lis = (double)s * is;
            double ris = (double)(s + 1) * is;
            Vector2 uv00 = new Vector2(lis, 1.0);
            Vector2 uv01 = new Vector2(lis, 0.0);
            Vector2 uv11 = new Vector2(ris, 0.0);
            Vector2 uv10 = new Vector2(ris, 1.0);
            Vector2 p00 = new Vector2(lis - 0.5, -0.5);
            Vector2 p01 = new Vector2(lis - 0.5, 0.5);
            Vector2 p11 = new Vector2(ris - 0.5, 0.5);
            Vector2 p10 = new Vector2(ris - 0.5, -0.5);
            Vector4 f = new Vector4();
            bw.write(f).write(uv00).write(p00).write(f).write(uv01).write(p01).write(f).write(uv11).write(p11);
            bw.write(f).write(uv11).write(p11).write(f).write(uv10).write(p10).write(f).write(uv00).write(p00);
        }
        this.positionsBuffer = ByteBuffer.allocateDirect(80000).order(ByteOrder.nativeOrder());
        this.positions = new BufferTexture[4];
        for (int i = 0; i < 4; ++i) {
            this.positions[i] = BufferTexture.createStream((GL3)gl3, (ByteBuffer)this.positionsBuffer, (int)80000, (int)34836);
        }
        bb.rewind();
        this.quad = VBO.createStaticVBO((GL)gl3, (ByteBuffer)bb, (long)bb.remaining());
        this.quadVAO = VAO.createVAO((GL3)gl3, (VBO)this.quad, (VBOLayout)this.layout, (Shader)this.shader);
    }

    public void draw(Matrix44 projection, double time, Contour contour, List<BezierSegments.Glyph> glyphs) {
        this.gl3.glDisable(2929);
        int paths = 0;
        ArrayList<Vector2> controlPoints = new ArrayList<Vector2>();
        for (Segment segment : contour) {
            for (Vector2 cp : segment.quadraticBezier()) {
                controlPoints.add(cp);
            }
            ++paths;
        }
        this.gl3.glEnable(3042);
        this.gl3.glBlendFunc(770, 771);
        BufferWriter bw = new BufferWriter(this.positionsBuffer);
        this.positionsBuffer.rewind();
        long ct = System.currentTimeMillis();
        for (BezierSegments.Glyph glyph : glyphs) {
            glyph.updateAnimation(ct);
            bw.write(this.mod(glyph.t, contour.segments.size()), glyph.offset, glyph.length, glyph.weight);
        }
        this.positionsBuffer.rewind();
        this.positions[this.index].write(this.gl3, this.positionsBuffer);
        this.shader.begin();
        this.positions[this.index].bindTexture();
        this.shader.setUniform("modelViewProjectionMatrix", projection.transpose());
        this.shader.setUniform("controlPoints", controlPoints.toArray(new Vector2[controlPoints.size()]));
        this.shader.setUniform1i("paths", paths);
        this.shader.setUniform1i("positions", 0);
        this.shader.setUniform("pathClosed", contour.closed);
        VBODrawer.drawInstances((GL)this.gl3, (VAO)this.quadVAO, (int)4, (int)(6 * this.segments), (int)glyphs.size());
        this.positions[this.index].unbindTexture();
        this.shader.end();
        this.index = (this.index + 1) % this.positions.length;
    }

    private double mod(double t, double size) {
        return (t % size + size) % size;
    }
}

