/*
 * Decompiled with CFR 0.152.
 */
package thimble.effects;

import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GL3;
import net.lustlab.rndr.math.Linear;
import net.lustlab.rndr.math.Matrix44;
import net.lustlab.rndr.math.Transforms;
import net.lustlab.rndr.math.Vector2;
import net.lustlab.rndr.math.Vector3;
import net.lustlab.rndr.shaders.FragmentShader;
import net.lustlab.rndr.shaders.Shader;
import net.lustlab.rndr.shaders.VertexShader;
import net.lustlab.rndr.vbo.BufferWriter;
import net.lustlab.rndr.vbo.VBO;
import net.lustlab.rndr.vbo.VBODrawer;
import net.lustlab.rndr.vbo.VBOLayout;

public class BarSwarm {
    GL3 gl3;
    VBO bar;
    VBOLayout layout;
    Shader shader;

    public BarSwarm(GL3 gl3) {
        this.gl3 = gl3;
        this.layout = new VBOLayout().textureCoordinate(2).normal(3).position(3);
        ByteBuffer buffer = ByteBuffer.allocateDirect(this.layout.size() * 6 * 6);
        BufferWriter bw = new BufferWriter(buffer);
        Vector3 nl = new Vector3(-1.0, 0.0, 0.0);
        Vector3 nr = new Vector3(1.0, 0.0, 0.0);
        Vector3 nu = new Vector3(0.0, 1.0, 0.0);
        Vector3 nd = new Vector3(0.0, -1.0, 0.0);
        Vector3 nf = new Vector3(0.0, 0.0, -1.0);
        Vector3 nb = new Vector3(0.0, 0.0, 1.0);
        Vector2 uv = new Vector2();
        double w = 0.05;
        double h = 0.0025;
        double d = 0.0025;
        Vector3 p000 = new Vector3(-w, h, -d);
        Vector3 p001 = new Vector3(-w, h, d);
        Vector3 p010 = new Vector3(-w, -h, -d);
        Vector3 p011 = new Vector3(-w, -h, d);
        Vector3 p100 = new Vector3(w, h, -d);
        Vector3 p101 = new Vector3(w, h, d);
        Vector3 p110 = new Vector3(w, -h, -d);
        Vector3 p111 = new Vector3(w, -h, d);
        bw.write(uv).write(nl).write(p000).write(uv).write(nl).write(p010).write(uv).write(nl).write(p011);
        bw.write(uv).write(nl).write(p000).write(uv).write(nl).write(p001).write(uv).write(nl).write(p011);
        bw.write(uv).write(nr).write(p100).write(uv).write(nr).write(p110).write(uv).write(nr).write(p111);
        bw.write(uv).write(nr).write(p100).write(uv).write(nr).write(p101).write(uv).write(nr).write(p111);
        bw.write(uv).write(nb).write(p111).write(uv).write(nb).write(p101).write(uv).write(nb).write(p001);
        bw.write(uv).write(nb).write(p111).write(uv).write(nb).write(p011).write(uv).write(nb).write(p001);
        bw.write(uv).write(nf).write(p110).write(uv).write(nf).write(p100).write(uv).write(nf).write(p000);
        bw.write(uv).write(nf).write(p110).write(uv).write(nf).write(p010).write(uv).write(nf).write(p000);
        bw.write(uv).write(nu).write(p000).write(uv).write(nu).write(p100).write(uv).write(nu).write(p101);
        bw.write(uv).write(nu).write(p000).write(uv).write(nu).write(p001).write(uv).write(nu).write(p101);
        bw.write(uv).write(nd).write(p010).write(uv).write(nd).write(p110).write(uv).write(nd).write(p111);
        bw.write(uv).write(nd).write(p010).write(uv).write(nd).write(p011).write(uv).write(nd).write(p111);
        buffer.rewind();
        this.bar = VBO.createStaticVBO((GL)gl3, (ByteBuffer)buffer, (long)(this.layout.size() * 6 * 6));
        this.shader = Shader.createShader((GL)gl3, (VertexShader)VertexShader.load((GL)gl3, (InputStream)this.getClass().getResourceAsStream("/shaders/barswarm/barswarm.vert")), (FragmentShader)FragmentShader.load((GL)gl3, (InputStream)this.getClass().getResourceAsStream("/shaders/barswarm/barswarm.frag")));
    }

    public void draw(Matrix44 projection, Matrix44 modelView, double time) {
        this.shader.begin();
        this.shader.setUniform("modelViewProjectionMatrix", Linear.multiply((Matrix44[])new Matrix44[]{projection, modelView}).transpose());
        this.shader.setUniform("modelViewMatrix", modelView.transpose());
        this.shader.setUniform("normalMatrix", Transforms.normal((Matrix44)modelView).transpose());
        this.shader.setUniform1f("time", (float)time);
        this.bar.bind();
        VBODrawer.drawInstances((GL)this.gl3, (Shader)this.shader, (VBO)this.bar, (VBOLayout)this.layout, (int)4, (int)36, (int)1000000);
        this.bar.unbind();
        this.shader.end();
    }
}

