/*
 * Decompiled with CFR 0.152.
 */
package thimble;

import com.jogamp.newt.event.KeyEvent;
import framer.Animatable;
import framer.AnimationCompletedCallback;
import framer.Easing;
import javax.media.opengl.GL;
import net.lustlab.rndr.color.Color;
import net.lustlab.rndr.fbo.ColorBuffer;
import net.lustlab.rndr.fbo.DepthBuffer;
import net.lustlab.rndr.fbo.RenderTarget;
import net.lustlab.rndr.font.FontMap;
import net.lustlab.rndr.font.image.FontImageMapManager;
import net.lustlab.rndr.gl.GLError;
import net.lustlab.rndr.image.Image;
import net.lustlab.rndr.image.ImageLoader;
import net.lustlab.rndr.math.Linear;
import net.lustlab.rndr.math.Matrix44;
import net.lustlab.rndr.math.Transforms;
import net.lustlab.rndr.math.Vector3;
import net.lustlab.rndr.math.Vector4;
import net.lustlab.rndr.sketch.SketchGL3;
import net.lustlab.rndr.text.Writer;
import net.lustlab.sndr.Player;
import thimble.effects.BarSwarm;
import thimble.effects.BarSwarmDeferred;
import thimble.effects.BezierSegments;
import thimble.effects.Cubes;
import thimble.effects.Floor;
import thimble.effects.GlyphScape;
import thimble.effects.Grids;
import thimble.effects.Logo;
import thimble.effects.ParticleDynamics;
import thimble.effects.ParticleSwarm;
import thimble.effects.PathDazzler;
import thimble.effects.RadialGradient;
import thimble.effects.Rider;
import thimble.effects.Terminal;
import thimble.post.Blur;
import thimble.post.Cutter;
import thimble.post.DOF;
import thimble.post.HandyZoom;
import thimble.post.Noise;
import thimble.post.SSAO;
import thimble.post.SSLR;

public class Thimble
extends SketchGL3 {
    Image dashedLine;
    ImageLoader imageLoader;
    RadialGradient radialGradient;
    Cutter cutter;
    GOLState golState = new GOLState();
    SegmentsState segmentsState = new SegmentsState();
    Player soundSystem;
    RiderState riderState;
    boolean exit = false;
    Logo logo;
    Terminal terminal;
    Blur blur;
    BarSwarm barSwarm;
    ParticleSwarm particleSwarm;
    ParticleDynamics particleDynamics;
    Noise noise;
    Floor floor;
    Cubes cubes;
    PathDazzler dazzler;
    GlyphScape glyphScape;
    BezierSegments bezierSegments;
    Grids grids;
    BarSwarmDeferred barSwarmDeferred;
    Rider rider;
    SSLR sslr;
    SSAO ssao;
    DOF dof;
    HandyZoom handyZoom;
    RenderTarget renderTarget;
    ColorBuffer colors;
    ColorBuffer normals;
    ColorBuffer positions;
    DepthBuffer depth;
    RenderTarget[] renderTargetPost;
    ColorBuffer[] colorsPost;
    AudioState audioState;
    DazzlerState dazzlerState;
    FontMap font;
    double time;
    double timeOffset = 0.0;
    int letterX;
    int letterY;
    String text = "flight LN" + (int)(1000.0 + Math.random() * 9000.0);

    Thimble(int args) {
        this.configuration.width = -1;
        this.configuration.height = -1;
        this.configuration.hideMouseCursor = true;
        this.configuration.title = "The nonstop Alaska experience";
    }

    public void setup() {
        this.imageLoader = new ImageLoader((GL)this.gl3);
        this.imageLoader.start();
        int adjustedHeight = (int)((double)this.width * 0.5625);
        System.out.println("adjusted height: " + adjustedHeight);
        this.dashedLine = Image.loadFromFile((GL)this.gl3, (String)"data/images/dashed-line-01.png");
        this.font = FontImageMapManager.fontMap((String)"data/fonts/SourceCodePro-Medium.ttf", (int)14);
        this.particleDynamics = new ParticleDynamics(this.gl3);
        this.logo = new Logo(this.gl3);
        this.barSwarmDeferred = new BarSwarmDeferred(this.gl3);
        this.floor = new Floor(this.gl3);
        this.cubes = new Cubes(this.gl3);
        this.grids = new Grids(this.gl3, 1280, 720);
        this.glyphScape = new GlyphScape(this.gl3, this.width, adjustedHeight);
        this.bezierSegments = new BezierSegments(this.gl3, this.width, adjustedHeight);
        this.terminal = new Terminal(this.gl3);
        this.radialGradient = new RadialGradient(this.gl3);
        this.cutter = new Cutter(this.gl3, this.width, adjustedHeight);
        this.rider = new Rider(this.gl3, this.imageLoader, this.width, adjustedHeight);
        this.noise = new Noise(this.gl3, this.width, adjustedHeight);
        this.handyZoom = new HandyZoom(this.gl3, this.width, adjustedHeight);
        this.dazzler = new PathDazzler(this.gl3);
        this.blur = new Blur(this.gl3, this.width, adjustedHeight);
        this.colors = ColorBuffer.create((GL)this.gl3, (int)this.width, (int)adjustedHeight);
        this.depth = DepthBuffer.create((GL)this.gl3, (int)this.width, (int)adjustedHeight);
        this.renderTarget = RenderTarget.create((GL)this.gl3, (int)this.width, (int)adjustedHeight).attach(this.colors).attach(this.depth).unbindTarget();
        this.colorsPost = new ColorBuffer[2];
        this.renderTargetPost = new RenderTarget[2];
        for (int i = 0; i < 2; ++i) {
            this.colorsPost[i] = ColorBuffer.create((GL)this.gl3, (int)this.width, (int)adjustedHeight, (int)34836);
            this.renderTargetPost[i] = RenderTarget.create((GL)this.gl3, (int)this.width, (int)adjustedHeight).attach(this.colorsPost[i]).unbindTarget();
        }
        this.golState.animate("x", 0.0, 0L).complete(new AnimationCompletedCallback(){

            public void animationCompleted(Animatable animatable) {
                Thimble.this.golState.delay((long)(500.0 + Math.random() * 500.0));
                Thimble.this.golState.animate(Thimble.index("opacity", Thimble.this.golState.index), 1.0, 500L, Easing.CubicInOut);
                Thimble.this.golState.add("rotation", Math.random() - 0.5, 1000L, Easing.CubicInOut);
                if (Thimble.this.time < 32.0) {
                    Thimble.this.golState.animate("scale", Math.random() * 2.0 + 1.5, 1000L, Easing.CubicInOut);
                    Thimble.this.golState.animate("x", 340.0 * (Math.random() - 0.5) + Thimble.this.grids.hotX * 1280.0 - 640.0, 2500L, Easing.CubicInOut);
                    Thimble.this.golState.animate("y", 340.0 * (Math.random() - 0.5) + Thimble.this.grids.hotY * 720.0 - 360.0, 2500L, Easing.CubicInOut);
                } else {
                    Thimble.this.golState.animate("scale", Math.random() * 1.0 + 1.5, 1000L, Easing.CubicInOut);
                }
                Thimble.this.golState.delay(2200L).add("x", 0.0, 0L).complete(new AnimationCompletedCallback(){

                    public void animationCompleted(Animatable animatable) {
                        Thimble.this.soundSystem.playBlip("data/audio/blips/5.ogg", false, (float)(0.25 + Math.random() * 0.25));
                    }
                });
                Thimble.this.golState.delay(300L);
                if (Thimble.this.time < 32.0) {
                    Thimble.this.golState.animate(Thimble.index("radius", Thimble.this.golState.index), 120.0 + Math.random() * 120.0, 500L, Easing.CubicInOut);
                }
                Thimble.this.golState.delay(400L);
                Thimble.this.golState.add("x", 0.0, 0L).complete(new AnimationCompletedCallback(){

                    public void animationCompleted(Animatable animatable) {
                        Thimble.this.soundSystem.playBlip("data/audio/blips/1.ogg", false, 0.5f);
                        if (Thimble.this.time > 32.0) {
                            Thimble.this.cutter.randomizeCuts(Thimble.this.time > 32.0);
                        }
                    }
                }).delay(-400L).delay(1000L).animate(Thimble.index("radius", Thimble.this.golState.index), 0.0, 2500L, Easing.CubicInOut).delay(1000L).animate(Thimble.index("opacity", Thimble.this.golState.index), 0.0, 1000L, Easing.CubicInOut).add("x", 0.0, 0L).complete((AnimationCompletedCallback)this);
                Thimble.this.golState.gx[Thimble.this.golState.index] = Thimble.this.grids.hotX * 1280.0;
                Thimble.this.golState.gy[Thimble.this.golState.index] = Thimble.this.grids.hotY * 720.0;
                Thimble.this.golState.index = (Thimble.this.golState.index + 1) % 2;
                if (Thimble.this.time < 32.0) {
                    Thimble.this.cutter.randomizeCuts(Thimble.this.time > 32.0);
                }
            }
        });
        this.dazzlerState = new DazzlerState();
        this.dazzlerState.updateAnimation();
        this.dazzlerState.animate("intensity", 0.0, 0L).complete(new AnimationCompletedCallback(){

            public void animationCompleted(Animatable animatable) {
                Thimble.this.dazzler.next();
                Thimble.this.soundSystem.playBlip("data/audio/blips/6.ogg", false, (float)(0.9 + Math.random() * 0.2));
                Thimble.this.dazzlerState.animate("intensity", 1.0, 200L, Easing.CubicInOut).delay((long)(Math.random() * 3000.0) + 2000L).animate("intensity", 0.0, 100L).complete((AnimationCompletedCallback)this);
            }
        });
        this.segmentsState.updateAnimation();
        this.segmentsState.animate("x", 0.0, 0L).complete(new AnimationCompletedCallback(){

            public void animationCompleted(Animatable animatable) {
                Thimble.this.bezierSegments.next();
                Thimble.this.segmentsState.animate("x", 0.0, (long)(Math.random() * 1000.0 + 3000.0)).complete((AnimationCompletedCallback)this);
                Thimble.this.soundSystem.playBlip("data/audio/blips/9.ogg", false, (float)((double)0.95f + Math.random() * 0.05));
            }
        });
        this.riderState = new RiderState();
        this.riderState.updateAnimation();
        this.riderState.animate("intensity", 0.0, 0L).complete(new AnimationCompletedCallback(){

            public void animationCompleted(Animatable animatable) {
                Thimble.this.rider.next();
                Thimble.this.soundSystem.playBlip("data/audio/blips/6.ogg", false, (float)(0.9 + Math.random() * 0.2));
                Thimble.this.riderState.animate("intensity", 1.0, 200L, Easing.CubicInOut).delay((long)(Math.random() * 5000.0)).animate("intensity", 0.0, 100L).complete((AnimationCompletedCallback)this);
            }
        });
        this.audioState = new AudioState();
        this.audioState.updateAnimation(0L);
        this.audioState.beepsPitch = 1.0;
        this.audioState.waitUntil(11000L);
        this.audioState.animate("rumble0Gain", 1.0, 3000L, Easing.CubicInOut);
        this.audioState.animate("rumble1Gain", 1.0, 3000L, Easing.CubicInOut);
        this.audioState.waitUntil(33000L);
        this.audioState.animate("beepsGain", 1.0, 12000L, Easing.CubicInOut);
        this.audioState.waitUntil(79000L);
        this.audioState.animate("beepsPitch", 0.95, 12000L, Easing.CubicInOut);
        this.audioState.animate("rumble0Gain", 1.0, 12000L, Easing.CubicInOut);
        this.audioState.animate("rumble1Gain", 1.0, 12000L, Easing.CubicInOut);
        this.audioState.animate("rumble0Pitch", 0.95, 12000L, Easing.CubicInOut);
        this.audioState.animate("rumble1Pitch", 0.95, 12000L, Easing.CubicInOut);
        this.audioState.waitUntil(110000L);
        this.audioState.animate("beepsPitch", 0.925, 12000L, Easing.CubicInOut);
        this.audioState.waitUntil(135000L);
        this.audioState.animate("beepsPitch", 0.9, 12000L, Easing.CubicInOut);
        this.audioState.animate("beepsGain", 0.0, 12000L, Easing.CubicInOut);
        this.audioState.waitUntil(160000L);
        this.audioState.animate("beepsPitch", 0.0, 12000L, Easing.CubicInOut);
        this.audioState.animate("rumble0Pitch", 0.0, 12000L, Easing.CubicInOut);
        this.audioState.animate("rumble1Pitch", 0.0, 12000L, Easing.CubicInOut);
        this.audioState.waitUntil(169000L);
        this.audioState.animate("beepsPitch", 0.0, 0L).complete(new AnimationCompletedCallback(){

            public void animationCompleted(Animatable animatable) {
                Thimble.this.soundSystem.playBlip("data/audio/blips/anouncement.ogg", false, 1.0f);
            }
        });
        this.rider.preload();
        this.soundSystem = new Player();
        this.soundSystem.playSound("data/audio/drones/drone-002.ogg", true, 1.2f);
        this.soundSystem.playSound("data/audio/drones/drone-001.ogg", true, 1.2f);
        this.soundSystem.playSound("data/audio/drones/drone-001.ogg", true, 1.0f);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.window.destroy();
        }
        if (keyEvent.getKeyCode() == 151) {
            this.timeOffset += 5.0;
        } else if (keyEvent.getKeyCode() == 149) {
            this.timeOffset -= 5.0;
        }
    }

    public void draw() {
        double rh = (double)this.width * 0.5625;
        double letterY = Math.max(0.0, ((double)this.height - rh) / 2.0);
        this.gl3.glViewport(0, (int)letterY, this.width, (int)rh);
        Writer writer = new Writer((GL)this.gl3);
        Matrix44 ortho = Transforms.ortho((double)0.0, (double)1280.0, (double)720.0, (double)0.0, (double)-1.0, (double)1.0);
        this.audioState.updateAnimation((long)(this.seconds() * 1000.0));
        this.soundSystem.getSource(0).setPitch((float)this.audioState.beepsPitch);
        this.soundSystem.getSource(1).setPitch((float)this.audioState.rumble0Pitch);
        this.soundSystem.getSource(2).setPitch((float)this.audioState.rumble1Pitch);
        this.soundSystem.getSource(0).setGain((float)this.audioState.beepsGain);
        this.soundSystem.getSource(1).setGain((float)this.audioState.rumble0Gain);
        this.soundSystem.getSource(2).setGain((float)this.audioState.rumble1Gain);
        this.background(Color.BLACK);
        Matrix44 projection = Transforms.perspective((double)90.0, (double)1.7777777777777777, (double)0.1, (double)100.0);
        double ex = Math.cos(this.seconds() * 0.1) * 1.0;
        double ez = Math.sin(this.seconds() * 0.1) * 1.0;
        double ey = 0.6 + 0.6 * Math.sin(this.seconds() * 0.4324);
        Matrix44 modelView = Transforms.lookAt((Vector3)new Vector3(ex, ey, ez), (Vector3)new Vector3(0.0, 0.0, 0.0), (Vector3)new Vector3(0.0, 1.0, 0.0));
        this.time = this.seconds() + this.timeOffset;
        if (this.time >= 0.0 && this.time < 15.0) {
            this.background(new Color(0.8196078431372549, 0.8666666666666667, 0.8666666666666667, 1.0));
            this.logo.draw(ortho, Matrix44.Identity);
            if (this.time > 10.0) {
                writer.projection(ortho);
                writer.modelView(Matrix44.Identity);
                writer.font(this.font);
                double w = writer.textWidth(this.text);
                writer.fill(Color.BLACK);
                writer.cursor(640.0 - w / 2.0, 360.0);
                GLError.check((GL)this.gl3);
                writer.text(this.text);
            }
        }
        if (this.time >= 15.0 && this.time < 22.0) {
            this.background(Color.BLACK);
            this.terminal.draw(this.drawer, ortho, this.time - 15.0);
        }
        if (this.time > 22.0 && this.time < 55.0) {
            this.background(new Color(0.8196078431372549, 0.8666666666666667, 0.8666666666666667, 1.0));
            this.golState.updateAnimation();
            this.renderTarget.bindTarget();
            this.background(new Color(0.8196078431372549, 0.8666666666666667, 0.8666666666666667, 1.0));
            modelView = Linear.multiply((Matrix44[])new Matrix44[]{Transforms.translate((Vector3)new Vector3(640.0, 360.0, 0.0)), Transforms.scale((double)this.golState.scale), Transforms.rotateZ((double)0.7853981633974483), Transforms.translate((Vector3)new Vector3(-640.0, -360.0, 0.0)), Transforms.translate((Vector3)new Vector3(-this.golState.x, -this.golState.y, 0.0))});
            this.grids.draw(ortho, modelView, Math.pow(this.audioState.beepsGain, 8.0));
            for (int i = 0; i < 2; ++i) {
                Vector4[] gradient = new Vector4[]{new Vector4(0.2235294117647059, 0.047058823529411764, 0.043137254901960784, 1.0 * this.golState.opacity[i]), new Vector4(0.2823529411764706, 0.24313725490196078, 0.26666666666666666, 1.0 * this.golState.opacity[i]), new Vector4(0.2784313725490196, 0.6470588235294118, 0.7372549019607844, 1.0 * this.golState.opacity[i]), new Vector4(1.0, 1.0, 1.0, 0.0)};
                this.radialGradient.draw(ortho, modelView, this.golState.radius[i], this.golState.gx[i], this.golState.gy[i], gradient);
                GLError.check((GL)this.gl3);
            }
            this.renderTarget.unbindTarget();
            double scrollOffset = 0.0;
            if (this.time > 35.0) {
                scrollOffset = this.time * 0.5;
            }
            this.cutter.draw(ortho, Matrix44.Identity, this.colors, null, scrollOffset);
            if (this.time > 35.0) {
                this.drawer.ortho(0.0, 1280.0, 720.0, 0.0, -1.0, 1.0);
                this.drawer.fill(Color.BLACK);
                this.drawer.stroke(Color.BLACK);
                double altitude = Math.pow((this.time - 35.0) / 4.0, 0.5) * 720.0;
                Writer writer2 = new Writer((GL)this.gl3);
                writer2.projection(ortho);
                writer2.modelView(Linear.multiply((Matrix44[])new Matrix44[]{Transforms.translate((Vector3)new Vector3(640.0, 360.0, 0.0)), Transforms.rotateZ((double)-1.5707963267948966), Transforms.translate((Vector3)new Vector3(-640.0, -360.0, 0.0))}));
                writer2.font(this.font);
                writer2.fill(Color.BLACK);
                writer2.cursor(altitude, -260.0);
                writer2.text("ALT/" + String.format("%.2f", altitude));
            }
        }
        if (this.time >= 55.0 && this.time < 85.0) {
            this.segmentsState.updateAnimation();
            this.background(new Color(0.8196078431372549, 0.8666666666666667, 0.8666666666666667, 1.0));
            this.bezierSegments.draw(ortho, this.time);
        }
        if (this.time > 85.0 && this.time < 115.0) {
            this.background(Color.BLACK);
            double f = Math.cos(this.seconds());
            Vector4[] gradient = new Vector4[]{new Vector4(1.0, 1.0, 1.0, 1.0), new Vector4(0.0, 0.0, 0.0, 1.0), new Vector4(f * 209.0 / 255.0, f * 221.0 / 255.0, f * 221.0 / 255.0, 1.0), new Vector4(0.0, 0.0, 0.0, 0.0)};
            this.radialGradient.draw(ortho, Matrix44.Identity, 200.0 + Math.cos(this.seconds() * 0.5) * 50.0, 640.0, 360.0, gradient);
            this.particleDynamics.draw(projection, modelView, this.time);
        }
        if (this.time >= 115.0 && this.time < 140.0) {
            this.background(Color.BLACK);
            this.riderState.updateAnimation();
            this.renderTarget.bindTarget();
            Matrix44 perspective = Transforms.perspective((double)120.0, (double)1.7777777777777777, (double)0.1, (double)100.0);
            Matrix44 view = Transforms.rotateY((double)(this.time * 0.02)).multiply(Transforms.rotateZ((double)(this.time * 0.05)));
            this.background(Color.BLACK);
            this.rider.draw(perspective, view, this.time, this.riderState.intensity);
            this.noise.draw(Transforms.ortho((double)0.0, (double)this.width, (double)rh, (double)0.0, (double)-1.0, (double)1.0), 1.0);
            this.renderTarget.unbindTarget();
            this.gl3.glViewport(0, (int)letterY, this.width, (int)rh);
            this.blur.draw(ortho, this.colors, this.time);
        }
        if (this.time >= 140.0 && this.time <= 165.0) {
            this.dazzlerState.updateAnimation();
            this.background(Color.BLACK);
            this.drawer.ortho(0.0, 1280.0, 720.0, 0.0, -1.0, 1.0);
            this.drawer.draw(this.dashedLine.texture, 0.0, 0.0, 1280.0, 720.0);
            this.dazzler.draw(ortho, Matrix44.Identity, this.time, this.dazzlerState.intensity);
        }
        if (this.time > 169.0 && this.time < 173.0) {
            this.background(Color.BLACK);
            Writer writer2 = new Writer((GL)this.gl3);
            writer2.projection(ortho);
            writer2.modelView(Linear.multiply((Matrix44[])new Matrix44[]{Transforms.translate((Vector3)new Vector3(640.0, 360.0, 0.0)), Transforms.rotateZ((double)-1.5707963267948966), Transforms.translate((Vector3)new Vector3(-640.0, -360.0, 0.0))}));
            writer2.font(this.font);
            writer2.fill(new Color(0.8196078431372549, 0.8666666666666667, 0.8666666666666667));
            double w = writer2.textWidth("EXIT/LEFT");
            writer2.cursor(640.0 - w / 2.0, -260.0);
            writer2.text("EXIT/LEFT");
            writer2 = new Writer((GL)this.gl3);
            writer2.projection(ortho);
            writer2.modelView(Linear.multiply((Matrix44[])new Matrix44[]{Transforms.translate((Vector3)new Vector3(640.0, 360.0, 0.0)), Transforms.rotateZ((double)1.5707963267948966), Transforms.translate((Vector3)new Vector3(-640.0, -360.0, 0.0))}));
            writer2.font(this.font);
            writer2.fill(new Color(0.8196078431372549, 0.8666666666666667, 0.8666666666666667));
            w = writer2.textWidth("EXIT/RIGHT");
            writer2.cursor(640.0 - w / 2.0, -260.0);
            writer2.text("EXIT/RIGHT");
        }
        if (this.time > 174.0 && !this.exit) {
            this.window.destroy();
            this.exit = true;
        }
    }

    public static void main(String[] args) {
        SketchGL3.run((SketchGL3)new Thimble(args.length));
    }

    public static String index(String name, int index) {
        return name + "[" + index + "]";
    }

    public static class AudioState
    extends Animatable {
        double beepsPitch = 1.0;
        double beepsGain = 0.0;
        double rumble0Pitch = 1.2;
        double rumble1Pitch = 1.0;
        double rumble0Gain = 0.0;
        double rumble1Gain = 0.0;

        AudioState() {
            super(0L);
        }
    }

    public static class DazzlerState
    extends Animatable {
        double intensity;
    }

    public static class RiderState
    extends Animatable {
        double intensity;
    }

    public static class SegmentsState
    extends Animatable {
        double x;
        double y;
        int index = 0;
    }

    public static class GOLState
    extends Animatable {
        double x;
        double y;
        double[] gx = new double[2];
        double[] gy = new double[2];
        double[] radius = new double[2];
        double[] opacity = new double[2];
        double rotation;
        double scale;
        int index = 0;
        double gridOpacity;
    }
}

