/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.packer;

import net.lustlab.packer.PackNode;
import net.lustlab.packer.Presplitter;
import net.lustlab.packer.Rectangle;
import net.lustlab.packer.Vector;

public class UniformPresplitter
implements Presplitter {
    int verticalDivisions;
    int horizontalDivisions;

    public UniformPresplitter(int verticalDivisions, int horizontalDivisions) {
        this.horizontalDivisions = horizontalDivisions;
        this.verticalDivisions = verticalDivisions;
    }

    public void setHorizontalDivisions(int horizontalDivisions) {
        this.horizontalDivisions = horizontalDivisions;
    }

    public void setVerticalDivisions(int verticalDivisions) {
        this.verticalDivisions = verticalDivisions;
    }

    public int getHorizontalDivisions() {
        return this.horizontalDivisions;
    }

    public int getVerticalDivisions() {
        return this.verticalDivisions;
    }

    @Override
    public PackNode[] split(PackNode input) {
        float splitWidth = input.getArea().width / (float)this.horizontalDivisions;
        float splitHeight = input.getArea().height / (float)this.verticalDivisions;
        PackNode[] result = new PackNode[this.verticalDivisions * this.horizontalDivisions];
        Vector topLeft = input.getArea().topLeft;
        for (int j = 0; j < this.verticalDivisions; ++j) {
            for (int i = 0; i < this.horizontalDivisions; ++i) {
                Rectangle rect = new Rectangle(topLeft.x + (float)i * splitWidth, topLeft.y + (float)j * splitHeight, splitWidth, splitHeight);
                result[j * this.horizontalDivisions + i] = new PackNode(rect);
            }
        }
        return result;
    }
}

