/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.packer;

import net.lustlab.packer.PackNode;
import net.lustlab.packer.Rectangle;
import net.lustlab.packer.Splitter;

public class SingleAxisGreedySplitter
implements Splitter {
    private float bias = 0.0f;
    int divisions = 1;

    public void setDivisions(int divisions) {
        this.divisions = divisions;
    }

    public void setBias(float bias) {
        this.bias = bias;
    }

    public float getBias() {
        return this.bias;
    }

    @Override
    public PackNode[] split(PackNode node, Rectangle rect) {
        int i;
        int i2;
        int dc = this.divisions * 2 + 1;
        float b = (this.bias + 1.0f) / 2.0f;
        float leftMargin = b * (node.getArea().width - rect.width) / (float)this.divisions;
        float topMargin = b * (node.getArea().height - rect.height) / (float)this.divisions;
        float rightMargin = (1.0f - b) * (node.getArea().width - rect.width) / (float)this.divisions;
        float bottomMargin = (1.0f - b) * (node.getArea().height - rect.height) / (float)this.divisions;
        float x0 = node.getArea().topLeft.x;
        float y0 = node.getArea().topLeft.y;
        PackNode[] results = new PackNode[dc];
        Rectangle[] rects = new Rectangle[dc];
        float dw = node.getArea().width - rect.width;
        float dh = node.getArea().height - rect.height;
        float[] widths = new float[dc];
        float[] heights = new float[dc];
        float[] xpos = new float[dc];
        float[] ypos = new float[dc];
        float x = node.getArea().topLeft.x;
        float y = node.getArea().topLeft.y;
        for (i2 = 0; i2 < dc; ++i2) {
            xpos[i2] = x;
            ypos[i2] = y;
            if (i2 < dc / 2) {
                x += leftMargin;
                widths[i2] = leftMargin;
                y += topMargin;
                heights[i2] = topMargin;
                continue;
            }
            if (i2 == dc / 2) {
                x += rect.width;
                widths[i2] = rect.width;
                y += rect.height;
                heights[i2] = rect.height;
                continue;
            }
            x += rightMargin;
            widths[i2] = rightMargin;
            y += bottomMargin;
            heights[i2] = bottomMargin;
        }
        if (dw > dh) {
            for (i2 = 0; i2 < dc; ++i2) {
                rects[i2] = new Rectangle(xpos[i2], y0, widths[i2], node.getArea().height);
            }
        } else {
            for (i2 = 0; i2 < dc; ++i2) {
                rects[i2] = new Rectangle(x0, ypos[i2], node.getArea().width, heights[i2]);
            }
        }
        int count = 0;
        int[] order = new int[dc];
        order[0] = dc / 2;
        for (i = 1; i < order.length; ++i) {
            order[i] = count++;
            if (count != order[0]) continue;
            ++count;
        }
        for (i = 0; i < dc; ++i) {
            results[i] = new PackNode(rects[order[i]]);
        }
        return results;
    }
}

