/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.packer;

import net.lustlab.packer.Clipper;
import net.lustlab.packer.Orderer;
import net.lustlab.packer.PackNode;
import net.lustlab.packer.Rectangle;
import net.lustlab.packer.Splitter;

public class Packer {
    private float sanding = 0.0f;
    private Clipper clipper = null;
    private Orderer orderer = null;
    private Splitter splitter = null;

    public Packer(Orderer orderer, Splitter splitter, Clipper clipper) {
        this.orderer = orderer;
        this.splitter = splitter;
        this.clipper = clipper;
    }

    public void setClipper(Clipper clipper) {
        this.clipper = clipper;
    }

    public void setOrderer(Orderer orderer) {
        this.orderer = orderer;
    }

    public void setSplitter(Splitter splitter) {
        this.splitter = splitter;
    }

    public void setSanding(float sanding) {
        this.sanding = sanding;
    }

    public float getSanding() {
        return this.sanding;
    }

    public PackNode insert(PackNode node, Rectangle rect) {
        return this.insert(node, rect, null);
    }

    public PackNode insert(PackNode node, Rectangle rect, Object data) {
        if (!node.isLeaf()) {
            int[] order;
            if (!(rect.width <= node.getArea().width) || !(rect.height <= node.getArea().height)) {
                return null;
            }
            for (int i : order = this.orderer.order(node, rect)) {
                PackNode newNode = this.insert(node.children[i], rect, data);
                if (newNode == null) continue;
                return newNode;
            }
            return null;
        }
        if (node.isTaken()) {
            return null;
        }
        if (node.getArea().width < rect.width || node.getArea().height < rect.height) {
            return null;
        }
        if (node.getArea().width == rect.width && node.getArea().height == rect.height) {
            if (this.clipper == null || this.clipper.inside(node.getArea(), rect)) {
                node.populate(data);
                return node;
            }
            return null;
        }
        node.children = this.splitter.split(node, rect);
        return this.insert(node.children[0], rect, data);
    }
}

