/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.packer;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.lustlab.packer.PackNode;
import net.lustlab.packer.PackNodeVisitor;

public class PackNodeTools {
    public static void visitNodes(PackNode root, PackNodeVisitor visitor) {
        Stack<PackNode> stack = new Stack<PackNode>();
        stack.push(root);
        while (!stack.empty()) {
            PackNode node = (PackNode)stack.pop();
            visitor.visit(node);
            if (node.isLeaf()) continue;
            for (PackNode c : node.children) {
                stack.push(c);
            }
        }
    }

    public static List<PackNode> findLeafNodes(PackNode root) {
        Stack<PackNode> stack = new Stack<PackNode>();
        ArrayList<PackNode> leafNodes = new ArrayList<PackNode>();
        stack.push(root);
        while (!stack.empty()) {
            PackNode node = (PackNode)stack.pop();
            if (node.isLeaf()) {
                leafNodes.add(node);
                continue;
            }
            for (PackNode c : node.children) {
                stack.push(c);
            }
        }
        return leafNodes;
    }
}

