/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.packer;

import net.lustlab.packer.PackNode;
import net.lustlab.packer.Rectangle;
import net.lustlab.packer.Splitter;

public class GreedySplitter
implements Splitter {
    private float horizontalBias = 0.0f;
    private float verticalBias = 0.0f;
    int horizontalDivisions = 1;
    int verticalDivisions = 1;

    public void setHorizontalDivisions(int horizontalDivisions) {
        this.horizontalDivisions = horizontalDivisions;
    }

    public void setVerticalDivisions(int verticalDivisions) {
        this.verticalDivisions = verticalDivisions;
    }

    public int getHorizontalDivisions() {
        return this.horizontalDivisions;
    }

    public int getVerticalDivisions() {
        return this.verticalDivisions;
    }

    public void setVerticalBias(float verticalBias) {
        this.verticalBias = verticalBias;
    }

    public void setHorizontalBias(float horizontalBias) {
        this.horizontalBias = horizontalBias;
    }

    public float getHorizontalBias() {
        return this.horizontalBias;
    }

    public float getVerticalBias() {
        return this.verticalBias;
    }

    @Override
    public PackNode[] split(PackNode node, Rectangle rect) {
        int i;
        int i2;
        int hc = this.horizontalDivisions * 2 + 1;
        int vc = this.verticalDivisions * 2 + 1;
        float hb = (this.horizontalBias + 1.0f) / 2.0f;
        float vb = (this.verticalBias + 1.0f) / 2.0f;
        float leftMargin = hb * (node.getArea().width - rect.width) / (float)this.horizontalDivisions;
        float topMargin = vb * (node.getArea().height - rect.height) / (float)this.verticalDivisions;
        float rightMargin = (1.0f - hb) * (node.getArea().width - rect.width) / (float)this.horizontalDivisions;
        float bottomMargin = (1.0f - vb) * (node.getArea().height - rect.height) / (float)this.verticalDivisions;
        PackNode[] result = new PackNode[hc * vc];
        Rectangle[] rects = new Rectangle[hc * vc];
        float x = node.getArea().topLeft.x;
        float y = node.getArea().topLeft.y;
        float[] xpos = new float[hc];
        float[] ypos = new float[vc];
        float[] widths = new float[hc];
        float[] heights = new float[vc];
        for (i2 = 0; i2 < hc; ++i2) {
            xpos[i2] = x;
            if (i2 < hc / 2) {
                x += leftMargin;
                widths[i2] = leftMargin;
                continue;
            }
            if (i2 == hc / 2) {
                x += rect.width;
                widths[i2] = rect.width;
                continue;
            }
            x += rightMargin;
            widths[i2] = rightMargin;
        }
        for (i2 = 0; i2 < vc; ++i2) {
            ypos[i2] = y;
            if (i2 < vc / 2) {
                y += topMargin;
                heights[i2] = topMargin;
                continue;
            }
            if (i2 == vc / 2) {
                y += rect.height;
                heights[i2] = rect.height;
                continue;
            }
            y += bottomMargin;
            heights[i2] = bottomMargin;
        }
        for (int j = 0; j < vc; ++j) {
            for (int i3 = 0; i3 < hc; ++i3) {
                rects[j * hc + i3] = new Rectangle(xpos[i3], ypos[j], widths[i3], heights[j]);
            }
        }
        int[] order = new int[hc * vc];
        order[0] = vc / 2 * hc + hc / 2;
        int count = 0;
        for (i = 1; i < order.length; ++i) {
            order[i] = count++;
            if (count != order[0]) continue;
            ++count;
        }
        for (i = 0; i < hc * vc; ++i) {
            result[i] = new PackNode(rects[order[i]]);
        }
        return result;
    }
}

