/*
 * Decompiled with CFR 0.152.
 */
package framer.easing;

public class Quad {
    public static double velocityIn(double t, double b, double c, double d) {
        return 2.0 * c * t / (d * d);
    }

    public static double velocityOut(double t, double b, double c, double d) {
        return -2.0 * c * (d - t) / (d * d);
    }

    public static double velocityInOut(double t, double b, double c, double d) {
        if (t / (d / 2.0) < 1.0) {
            return 4.0 * c * t / (d * d);
        }
        return 4.0 * c * (d - t) / (d * d);
    }

    public static double easeIn(double t, double b, double c, double d) {
        return c * (t /= d) * t + b;
    }

    public static double easeOut(double t, double b, double c, double d) {
        return -c * (t /= d) * (t - 2.0) + b;
    }

    public static double easeInOut(double t, double b, double c, double d) {
        double d2;
        t /= d / 2.0;
        if (d2 < 1.0) {
            return c / 2.0 * t * t + b;
        }
        return -c / 2.0 * ((t -= 1.0) * (t - 2.0) - 1.0) + b;
    }
}

