/*
 * Decompiled with CFR 0.152.
 */
package framer.easing;

public class Elastic {
    public static double velocityIn(double t, double b, double c, double d) {
        return c * Math.pow(2.0, 10.0 * t / d) * (0.0160887 * Math.sin(20.944 * t / d) + 0.0143284 * Math.cos(20.944 * t / d)) / d;
    }

    public static double velocityOut(double t, double b, double c, double d) {
        return Math.pow(2.0, -(10.0 * t) / d) * (20.944 * c * Math.cos(1.5708 - 20.944 * t / d) - 6.93147 * c * Math.sin(20.944 * (t - 0.075 * d) / d)) / d;
    }

    public static double velocityInOut(double t, double b, double c, double d) {
        if (t / (d / 2.0) < 1.0) {
            return c * Math.pow(2.0, 20.0 * t / d) * (0.0160887 * Math.sin(41.888 * t / d) + 0.0143284 * Math.cos(41.888 * t / d)) / d;
        }
        return Math.pow(2.0, -(20.0 * t) / d) * (20.944 * c * Math.cos(1.5708 - 20.944 * t / d) - 6.93147 * c * Math.sin(20.944 * (t - 0.075 * d) / d)) / d;
    }

    public static double easeIn(double t, double b, double c, double d) {
        if (t == 0.0) {
            return b;
        }
        if ((t /= d) == 1.0) {
            return b + c;
        }
        double p = d * (double)0.3f;
        double s = p / 4.0;
        return -(c * Math.pow(2.0, 10.0 * (t -= 1.0)) * Math.sin((t * d - s) * (Math.PI * 2) / p)) + b;
    }

    public static double easeOut(double t, double b, double c, double d) {
        if (t == 0.0) {
            return b;
        }
        if ((t /= d) == 1.0) {
            return b + c;
        }
        double p = d * (double)0.3f;
        double a = c;
        double s = p / 4.0;
        return a * Math.pow(2.0, -10.0 * t) * Math.sin((t * d - s) * (Math.PI * 2) / p) + c + b;
    }

    public static double easeInOut(double t, double b, double c, double d) {
        if (t == 0.0) {
            return b;
        }
        if ((t /= d / 2.0) == 2.0) {
            return b + c;
        }
        double p = d * 0.45000001788139343;
        double a = c;
        double s = p / 4.0;
        if (t < 1.0) {
            return -0.5 * (a * Math.pow(2.0, 10.0 * (t -= 1.0)) * Math.sin((t * d - s) * (Math.PI * 2) / p)) + b;
        }
        return a * Math.pow(2.0, -10.0 * (t -= 1.0)) * Math.sin((t * d - s) * (Math.PI * 2) / p) * 0.5 + c + b;
    }
}

