/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.text;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GL3;
import net.lustlab.rndr.color.Color;
import net.lustlab.rndr.font.FontMap;
import net.lustlab.rndr.font.FontMapRenderer;
import net.lustlab.rndr.font.image.FontImageMapRenderer;
import net.lustlab.rndr.font.image.FontImageMapRendererGL3;
import net.lustlab.rndr.font.vector.FontVectorMap;
import net.lustlab.rndr.font.vector.FontVectorMapRenderer;
import net.lustlab.rndr.font.vector.FontVectorMapRendererGL3;
import net.lustlab.rndr.math.Matrix44;
import net.lustlab.rndr.text.Box;
import net.lustlab.rndr.text.Cursor;
import net.lustlab.rndr.text.Style;

public class Writer {
    Matrix44 projection;
    Matrix44 modelView;
    public List<RenderToken> renderTokens;
    public Cursor cursor = new Cursor(0.0, 0.0);
    public Style style = new Style();
    public Box box = new Box(0.0, 0.0, 8.988465674311579E307, 8.988465674311579E307);
    public Box clip = new Box(0.0, 0.0, 4.4942328371557893E307, 4.4942328371557893E307);
    private Stack<Cursor> cursorStack = new Stack();
    private Stack<Box> boxStack = new Stack();
    private Stack<Box> clipStack = new Stack();
    private Stack<Style> styleStack = new Stack();
    private FontMapRenderer renderer;
    private FontMapRenderer imageRenderer;
    private FontMapRenderer vectorRenderer;
    private GL2 gl2;
    private GL3 gl3;

    public Writer(GL gl) {
        if (gl.isGL2()) {
            this.imageRenderer = new FontImageMapRenderer(gl);
            this.vectorRenderer = new FontVectorMapRenderer();
            this.gl2 = gl.getGL2();
        } else {
            this.imageRenderer = new FontImageMapRendererGL3(gl);
            this.vectorRenderer = new FontVectorMapRendererGL3();
            this.gl3 = gl.getGL3();
        }
    }

    public Writer projection(Matrix44 projection) {
        this.projection = projection;
        return this;
    }

    public Writer modelView(Matrix44 modelView) {
        this.modelView = modelView;
        return this;
    }

    public Color fill() {
        return this.style.fill;
    }

    public Writer fill(Color color) {
        this.style.fill = new Color(color);
        return this;
    }

    public Color stroke() {
        return this.style.stroke;
    }

    public Writer stroke(Color color) {
        this.style.stroke = new Color(color);
        return this;
    }

    public Writer tracking(double tracking) {
        this.style.tracking = tracking;
        return this;
    }

    public double tracking() {
        return this.style.tracking;
    }

    public Writer ellipsis(String ellipsis) {
        this.style.ellipsis = new String(ellipsis);
        return this;
    }

    public Writer noEllipsis() {
        this.style.ellipsis = null;
        return this;
    }

    public Writer text(String text) {
        block3: {
            block2: {
                this.renderer = this.style.font instanceof FontVectorMap ? this.vectorRenderer : this.imageRenderer;
                this.renderer.clip(this.clip.x, this.clip.y, this.clip.width, this.clip.height);
                this.renderer.fill(this.style.fill);
                this.renderer.stroke(this.style.stroke);
                this.renderTokens = this.makeRenderTokens(text, false);
                if (this.gl2 == null) break block2;
                for (RenderToken renderToken : this.renderTokens) {
                    renderToken.rectangles = this.renderer.render((GL)this.gl2, this.style.font, renderToken.token, (float)renderToken.x, (float)renderToken.y, renderToken.tracking);
                }
                break block3;
            }
            if (this.gl3 == null) break block3;
            for (RenderToken renderToken : this.renderTokens) {
                renderToken.rectangles = this.renderer.render(this.gl3, this.projection, this.modelView, this.style.font, renderToken.token, (float)renderToken.x, (float)renderToken.y, renderToken.tracking);
            }
        }
        return this;
    }

    public Writer textFit(String text, FontMap ... fontMaps) {
        for (int f = 0; f < fontMaps.length; ++f) {
            FontMap fontMap = fontMaps[f];
            this.pushStyle();
            this.font(fontMap);
            this.renderer = this.style.font instanceof FontVectorMap ? this.vectorRenderer : this.imageRenderer;
            this.renderer.fill(this.style.fill);
            this.renderer.stroke(this.style.stroke);
            this.renderTokens = this.makeRenderTokens(text, f != fontMaps.length - 1);
            if (this.renderTokens != null) {
                if (this.gl2 != null) {
                    for (RenderToken renderToken : this.renderTokens) {
                        renderToken.rectangles = this.renderer.render((GL)this.gl2, this.style.font, renderToken.token, (float)renderToken.x, (float)renderToken.y, renderToken.tracking);
                    }
                } else if (this.gl3 != null) {
                    for (RenderToken renderToken : this.renderTokens) {
                        renderToken.rectangles = this.renderer.render(this.gl3, this.projection, this.modelView, this.style.font, renderToken.token, (float)renderToken.x, (float)renderToken.y, renderToken.tracking);
                    }
                }
            }
            this.popStyle();
            if (this.renderTokens != null) break;
        }
        return this;
    }

    public double textWidth(String text) {
        this.renderer = this.style.font instanceof FontVectorMap ? this.vectorRenderer : this.imageRenderer;
        return this.renderer.width(this.style.font, text) + this.style.tracking * (double)text.length();
    }

    public Writer blindText(String text) {
        this.makeRenderTokens(text, false);
        return this;
    }

    private List<RenderToken> makeRenderTokens(String text, boolean mustFit) {
        this.renderer = this.style.font instanceof FontVectorMap ? this.vectorRenderer : this.imageRenderer;
        boolean fits = true;
        String[] lines = text.split("((?<=\n)|(?=\n))");
        ArrayList<String> tokens = new ArrayList<String>();
        for (String line : lines) {
            String[] lineTokens;
            for (String token : lineTokens = line.split(" ")) {
                tokens.add(token);
            }
        }
        double spaceWidth = this.renderer.width(this.style.font, " ") + this.style.tracking;
        double verticalSpace = this.style.font.fontHeight() + this.style.font.leading() + this.style.leading;
        ArrayList<RenderToken> renderTokens = new ArrayList<RenderToken>();
        Cursor tempCursor = new Cursor(this.cursor);
        for (int i = 0; i < tokens.size(); ++i) {
            String token = (String)tokens.get(i);
            if (token.equals("\n")) {
                tempCursor.x = this.box.x;
                tempCursor.y += verticalSpace;
                continue;
            }
            double width = this.renderer.width(this.style.font, token) + this.style.tracking * (double)token.length();
            if (tempCursor.x + width < this.box.x + this.box.width && tempCursor.y <= this.box.y + this.box.height) {
                renderTokens.add(new RenderToken(token, tempCursor.x, tempCursor.y, this.style.tracking));
            } else {
                if (!(tempCursor.y <= this.box.y + this.box.height)) {
                    fits = false;
                }
                if (tempCursor.y + verticalSpace <= this.box.y + this.box.height) {
                    tempCursor.y += verticalSpace;
                    tempCursor.x = this.box.x;
                    renderTokens.add(new RenderToken(token, tempCursor.x, tempCursor.y, this.style.tracking));
                } else {
                    if (!mustFit && this.style.ellipsis != null && this.cursor.y <= this.box.y + this.box.height) {
                        renderTokens.add(new RenderToken(this.style.ellipsis, tempCursor.x, tempCursor.y, this.style.tracking));
                        break;
                    }
                    fits = false;
                }
            }
            tempCursor.x += width;
            if (i == tokens.size() - 1) continue;
            tempCursor.x += spaceWidth;
        }
        if (fits || !fits && !mustFit) {
            this.cursor = new Cursor(tempCursor);
        } else {
            renderTokens = null;
        }
        return renderTokens;
    }

    public Writer leading(double leading) {
        this.style.leading = leading;
        return this;
    }

    public double leading() {
        return this.style.leading;
    }

    public Writer font(FontMap font) {
        this.style.font = font;
        return this;
    }

    public FontMap font() {
        return this.style.font;
    }

    public Writer cursor(double x, double y) {
        this.cursor.x = x;
        this.cursor.y = y;
        return this;
    }

    public Writer cursorX(double x) {
        this.cursor.x = x;
        return this;
    }

    public Writer cursorY(double y) {
        this.cursor.y = y;
        return this;
    }

    public Writer pushClip() {
        this.clipStack.push(new Box(this.clip));
        return this;
    }

    public Writer popClip() {
        this.clip = this.clipStack.pop();
        return this;
    }

    public Writer clip(double x, double y, double width, double height) {
        this.clip = new Box(x, y, width, height);
        return this;
    }

    public Writer noClip() {
        this.clip = new Box(-1.0, -1.0, 8192.0, 8192.0);
        return this;
    }

    public Box clip() {
        return this.clip;
    }

    public Writer pushCursor() {
        this.cursorStack.push(new Cursor(this.cursor));
        return this;
    }

    public Writer popCursor() {
        this.cursor = new Cursor(this.cursorStack.pop());
        return this;
    }

    public Writer pushBox() {
        this.boxStack.push(new Box(this.box));
        return this;
    }

    public Writer popBox() {
        this.box = this.boxStack.pop();
        return this;
    }

    public Writer style(Style style) {
        this.style = new Style(style);
        return this;
    }

    public Writer pushStyle() {
        this.styleStack.push(new Style(this.style));
        return this;
    }

    public Writer popStyle() {
        this.style = this.styleStack.pop();
        return this;
    }

    public Writer newLine() {
        this.cursor.x = this.box.x;
        this.cursor.y += this.style.font.fontHeight() + this.style.font.leading() + this.style.leading;
        return this;
    }

    public Writer gaplessNewLine() {
        this.cursor.x = this.box.x;
        this.cursor.y += this.style.font.fontHeight();
        return this;
    }

    public Writer move(double x, double y) {
        this.cursor.x += x;
        this.cursor.y += y;
        return this;
    }

    public Box box() {
        return this.box;
    }

    public Writer box(Box box) {
        box = new Box(box);
        this.cursor.x = box.x;
        this.cursor.y = box.y;
        return this;
    }

    public Writer box(double x, double y, double width, double height) {
        this.box = new Box(x, y, width, height);
        this.cursor.x = x;
        this.cursor.y = y;
        return this;
    }

    public Writer line(double x, double y, double width) {
        return this.box(x, y, width, 0.0);
    }

    public Writer box(double x, double y, double width) {
        this.box = new Box(x, y, width, 8192.0);
        this.cursor.x = x;
        this.cursor.y = y;
        return this;
    }

    public Writer noBox() {
        this.box = new Box(0.0, 0.0, 8.988465674311579E307, 8.988465674311579E307);
        return this;
    }

    public Writer moveBox(int x, int y) {
        this.box.x += (double)x;
        this.box.y += (double)y;
        return this;
    }

    public Writer boxPosition(int x, int y) {
        this.box.x = x;
        this.box.y = y;
        return this;
    }

    public Writer boxSize(int width, int height) {
        this.box.width = width;
        this.box.height = height;
        return this;
    }

    public static class RenderToken {
        double x;
        double y;
        double tracking;
        String token;
        public List<FontMapRenderer.CharacterRectangle> rectangles;

        RenderToken(String token, double x, double y, double tracking) {
            this.x = x;
            this.y = y;
            this.tracking = tracking;
            this.token = token;
        }
    }
}

