/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.svg;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.lustlab.rndr.color.Color;
import net.lustlab.rndr.math.Matrix44;
import net.lustlab.rndr.math.Transform;
import net.lustlab.rndr.math.Vector2;
import net.lustlab.rndr.svg.Command;
import net.lustlab.rndr.svg.Element;
import net.lustlab.rndr.svg.Group;
import net.lustlab.rndr.svg.Path;
import net.lustlab.rndr.svg.SVGDocument;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.parser.Parser;

public class SVGLoader {
    static Logger logger = Logger.getLogger(SVGLoader.class.getName());

    public static SVGDocument loadSVG(String filename) throws IOException {
        File f = new File(filename);
        FileInputStream fis = new FileInputStream(f);
        return SVGLoader.loadSVG(fis);
    }

    public static void handlePolygon(Group group, SVGDocument doc, org.jsoup.nodes.Element e) {
        String[] tokens = e.attr("points").split("[ ,]");
        ArrayList<Vector2> points = new ArrayList<Vector2>();
        for (int i = 0; i < tokens.length / 2; ++i) {
            points.add(new Vector2(new Double(tokens[i * 2].trim()), new Double(tokens[i * 2 + 1].trim())));
        }
        Path path = new Path();
        path.id = e.id();
        SVGLoader.parseDrawAttributes(e, path);
        path.commands.add(new Command('M', ((Vector2)points.get((int)0)).x, ((Vector2)points.get((int)0)).y));
        for (int i = 1; i < points.size(); ++i) {
            path.commands.add(new Command('L', ((Vector2)points.get((int)i)).x, ((Vector2)points.get((int)i)).y));
        }
        path.commands.add(new Command('z', new Double[0]));
        group.elements.add(path);
    }

    public static void handleRectangle(Group group, SVGDocument doc, org.jsoup.nodes.Element e) {
        if (e.attr("id").equals("background")) {
            return;
        }
        Double x = e.attr("x").length() == 0 ? 0.0 : new Double(e.attr("x"));
        Double y = e.attr("y").length() == 0 ? 0.0 : new Double(e.attr("y"));
        Double width = new Double(e.attr("width"));
        Double height = new Double(e.attr("height"));
        Path path = new Path();
        path.id = e.id();
        SVGLoader.parseDrawAttributes(e, path);
        SVGLoader.parseTransform(e, path);
        path.commands.add(new Command('M', x, y));
        path.commands.add(new Command('h', width));
        path.commands.add(new Command('v', height));
        path.commands.add(new Command('h', -width.doubleValue()));
        path.commands.add(new Command('z', new Double[0]));
        group.elements.add(path);
    }

    public static void handleLine(Group group, SVGDocument doc, org.jsoup.nodes.Element e) {
        Double x1 = new Double(e.attr("x1"));
        Double x2 = new Double(e.attr("x2"));
        Double y1 = new Double(e.attr("y1"));
        Double y2 = new Double(e.attr("y2"));
        Path path = new Path();
        path.id = e.id();
        SVGLoader.parseDrawAttributes(e, path);
        Command c0 = new Command();
        c0.op = (char)77;
        c0.operands.add(x1);
        c0.operands.add(y1);
        Command c1 = new Command();
        c1.op = (char)76;
        c1.operands.add(x2);
        c1.operands.add(y2);
        path.commands.add(c0);
        path.commands.add(c1);
        group.elements.add(path);
    }

    public static void handlePath(Group group, SVGDocument doc, org.jsoup.nodes.Element e) {
        Path path = new Path();
        path.id = e.id();
        SVGLoader.parseDrawAttributes(e, path);
        String[] rawCommands = e.attr("d").split("(?=[MmZzLlHhVvCcSsQqTtAa])");
        Pattern numbers = Pattern.compile("[-+]?[0-9]*[.]?[0-9]+(?:[eE][-+]?[0-9]+)?");
        for (String rawCommand : rawCommands) {
            if (rawCommand.length() <= 0) continue;
            Command command = new Command();
            command.op = rawCommand.charAt(0);
            Matcher numberMatcher = numbers.matcher(rawCommand);
            while (numberMatcher.find()) {
                command.operands.add(new Double(numberMatcher.group()));
            }
            path.commands.add(command);
        }
        group.elements.add(path);
    }

    private static void parseTransform(org.jsoup.nodes.Element e, Element target) {
        Pattern p = Pattern.compile("(matrix|translate|scale|rotate|skewX|skewY)\\(.+\\)");
        Matcher m = p.matcher(e.attr("transform"));
        while (m.find()) {
            String token = m.group();
            if (!token.startsWith("matrix")) continue;
            List<Double> operands = SVGLoader.getTransformOperands(token);
            Matrix44 mat = new Matrix44(operands.get(0), operands.get(2), 0.0, operands.get(4), operands.get(1), operands.get(3), 0.0, operands.get(5), 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            target.transform = new Transform(mat);
        }
    }

    private static List<Double> getTransformOperands(String token) {
        Pattern number = Pattern.compile("-?[0-9\\.eE\\-]+");
        Matcher nm = number.matcher(token);
        ArrayList<Double> operands = new ArrayList<Double>();
        while (nm.find()) {
            Double n = new Double(nm.group());
            operands.add(n);
        }
        return operands;
    }

    private static void parseDrawAttributes(org.jsoup.nodes.Element e, Path path) {
        path.fill = e.attr("fill").length() == 0 ? new Color(0.0, 0.0, 0.0, 1.0) : SVGLoader.parseColor(e.attr("fill"));
        path.stroke = e.attr("stroke").length() == 0 ? null : SVGLoader.parseColor(e.attr("stroke"));
    }

    public static void handleGroup(Group parent, SVGDocument doc, org.jsoup.nodes.Element e) {
        Group group = new Group();
        group.id = e.id();
        if (parent == null) {
            doc.groups.add(group);
        } else {
            parent.elements.add(group);
        }
        for (org.jsoup.nodes.Element c : e.children()) {
            if (c.tagName().equals("g")) {
                SVGLoader.handleGroup(group, doc, c);
            }
            if (c.tagName().equals("path")) {
                SVGLoader.handlePath(group, doc, c);
            }
            if (c.tagName().equals("line")) {
                SVGLoader.handleLine(group, doc, c);
            }
            if (c.tagName().equals("polygon")) {
                SVGLoader.handlePolygon(group, doc, c);
            }
            if (c.tagName().equals("rect")) {
                SVGLoader.handleRectangle(group, doc, c);
            }
            if (c.tagName().equals("ellipse")) {
                SVGLoader.handleEllipse(group, doc, c);
            }
            if (!c.tagName().equals("polyline")) continue;
            SVGLoader.handlePolyline(group, doc, c);
        }
    }

    public static Color parseColor(String scolor) {
        if (scolor.equals("none")) {
            return null;
        }
        if (scolor.startsWith("#")) {
            Long v = Long.decode(scolor);
            int vi = v.intValue();
            int r = vi >> 16 & 0xFF;
            int g = vi >> 8 & 0xFF;
            int b = vi & 0xFF;
            Color color = new Color((double)r / 255.0, (double)g / 255.0, (double)b / 255.0, 1.0);
            return color;
        }
        throw new RuntimeException("could not parse color: " + scolor);
    }

    public static SVGDocument loadSVG(InputStream stream) throws IOException {
        SVGDocument svg = new SVGDocument();
        Document doc = Jsoup.parse((InputStream)stream, (String)"UTF-8", (String)"", (Parser)Parser.xmlParser());
        org.jsoup.nodes.Element root = doc.select("svg").first();
        for (org.jsoup.nodes.Element e : root.children()) {
            Group g;
            if (e.tagName().equals("g")) {
                SVGLoader.handleGroup(null, svg, e);
            }
            if (e.tagName().equals("path")) {
                g = new Group();
                svg.groups.add(g);
                SVGLoader.handlePath(g, svg, e);
            }
            if (e.tagName().equals("line")) {
                g = new Group();
                svg.groups.add(g);
                SVGLoader.handleLine(g, svg, e);
            }
            if (e.tagName().equals("polygon")) {
                g = new Group();
                svg.groups.add(g);
                SVGLoader.handlePolygon(g, svg, e);
            }
            if (e.tagName().equals("rect")) {
                g = new Group();
                svg.groups.add(g);
                SVGLoader.handleRectangle(g, svg, e);
            }
            if (e.tagName().equals("ellipse")) {
                g = new Group();
                svg.groups.add(g);
                SVGLoader.handleEllipse(g, svg, e);
            }
            if (!e.tagName().equals("polyline")) continue;
            g = new Group();
            svg.groups.add(g);
            SVGLoader.handlePolyline(g, svg, e);
        }
        return svg;
    }

    private static void handlePolyline(Group group, SVGDocument svg, org.jsoup.nodes.Element e) {
        Path path = new Path();
        path.id = e.id();
        SVGLoader.parseDrawAttributes(e, path);
        SVGLoader.parseTransform(e, path);
        String[] tokens = e.attr("points").split("[ ,]");
        path.commands.add(new Command('M', new Double(tokens[0]), new Double(tokens[1])));
        for (int i = 1; i < tokens.length / 2; ++i) {
            path.commands.add(new Command('L', new Double(tokens[i * 2]), new Double(tokens[i * 2 + 1])));
        }
        group.elements.add(path);
    }

    private static void handleEllipse(Group group, SVGDocument svg, org.jsoup.nodes.Element e) {
        logger.fine("handling ellipse " + group + " " + e);
        Double x = e.attr("cx").length() == 0 ? 0.0 : new Double(e.attr("cx"));
        Double y = e.attr("cy").length() == 0 ? 0.0 : new Double(e.attr("cy"));
        Double width = new Double(e.attr("rx")) * 2.0;
        Double height = new Double(e.attr("ry")) * 2.0;
        x = x - width / 2.0;
        y = y - height / 2.0;
        double kappa = 0.5522848;
        double ox = width / 2.0 * kappa;
        double oy = height / 2.0 * kappa;
        double xe = x + width;
        double ye = y + height;
        double xm = x + width / 2.0;
        double ym = y + height / 2.0;
        Path path = new Path();
        path.id = e.id();
        SVGLoader.parseDrawAttributes(e, path);
        SVGLoader.parseTransform(e, path);
        path.commands.add(new Command('M', x, ym));
        path.commands.add(new Command('C', x, ym - oy, xm - ox, y, xm, y));
        path.commands.add(new Command('C', xm + ox, y, xe, ym - oy, xe, ym));
        path.commands.add(new Command('C', xe, ym + oy, xm + ox, ye, xm, ye));
        path.commands.add(new Command('C', xm - ox, ye, x, ym + oy, x, ym));
        path.commands.add(new Command('z', new Double[0]));
        group.elements.add(path);
    }
}

