/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.svg;

import java.util.ArrayList;
import java.util.List;
import net.lustlab.rndr.color.Color;
import net.lustlab.rndr.draw.Contour;
import net.lustlab.rndr.draw.Segment;
import net.lustlab.rndr.draw.Shape;
import net.lustlab.rndr.math.Transform;
import net.lustlab.rndr.math.Vector2;
import net.lustlab.rndr.svg.Command;
import net.lustlab.rndr.svg.Element;

public class Path
extends Element {
    public List<Command> commands = new ArrayList<Command>();
    public Color fill;
    public Color stroke;

    List<Path> getCompounds() {
        ArrayList<Path> compounds = new ArrayList<Path>();
        ArrayList<Integer> compoundIndices = new ArrayList<Integer>();
        int index = 0;
        for (Command c : this.commands) {
            if (c.op == 'M') {
                compoundIndices.add(index);
            }
            ++index;
        }
        for (int i = 0; i < compoundIndices.size(); ++i) {
            int cs = (Integer)compoundIndices.get(i);
            int ce = i + 1 < compoundIndices.size() ? ((Integer)compoundIndices.get(i + 1)).intValue() : this.commands.size();
            Path path = new Path();
            path.commands.addAll(this.commands.subList(cs, ce));
            compounds.add(path);
        }
        return compounds;
    }

    public String toString() {
        return "Path{commands=" + this.commands + ", fill=" + this.fill + ", stroke=" + this.stroke + '}';
    }

    public Shape shape() {
        Shape shape = new Shape();
        shape.fill = this.fill != null ? this.fill.copy() : null;
        shape.stroke = this.stroke != null ? this.stroke.copy() : null;
        shape.transform = new Transform(this.transform);
        shape.id = this.id;
        Vector2 cursor = new Vector2();
        Vector2 anchor = cursor.copy();
        Vector2 relativeControl = new Vector2(0.0, 0.0);
        for (Path compound : this.getCompounds()) {
            Contour contour = new Contour();
            block16: for (Command command : compound.commands) {
                switch (command.op) {
                    case 'M': {
                        cursor = command.vector(0, 1);
                        anchor = cursor.copy();
                        continue block16;
                    }
                    case 'm': {
                        cursor = cursor.add(command.vector(0, 1));
                        anchor = cursor.copy();
                        continue block16;
                    }
                    case 'L': {
                        contour.segments.add(new Segment(new Vector2(cursor), command.vector(0, 1)));
                        cursor = command.vector(0, 1).copy();
                        continue block16;
                    }
                    case 'l': {
                        contour.segments.add(new Segment(new Vector2(cursor), cursor.add(command.vector(0, 1))));
                        cursor = cursor.add(command.vector(0, 1));
                        continue block16;
                    }
                    case 'h': {
                        contour.segments.add(new Segment(new Vector2(cursor), cursor.add(command.vector(0, -1))));
                        cursor = cursor.add(command.vector(0, -1));
                        continue block16;
                    }
                    case 'H': {
                        Vector2 target = new Vector2(command.operands.get(0), cursor.y);
                        contour.segments.add(new Segment(new Vector2(cursor), target));
                        cursor = target.copy();
                        continue block16;
                    }
                    case 'v': {
                        Vector2 target = cursor.add(command.vector(-1, 0));
                        contour.segments.add(new Segment(new Vector2(cursor), target));
                        cursor = target.copy();
                        continue block16;
                    }
                    case 'V': {
                        Vector2 target = new Vector2(cursor.x, command.operands.get(0));
                        contour.segments.add(new Segment(new Vector2(cursor), target));
                        cursor = target.copy();
                        continue block16;
                    }
                    case 'C': {
                        Vector2[] points = command.vectors();
                        contour.segments.add(new Segment(new Vector2(cursor), points[0], points[1], points[2]));
                        cursor = points[2].copy();
                        relativeControl = points[1].subtract(points[2]);
                        continue block16;
                    }
                    case 'c': {
                        Vector2[] points = command.vectors();
                        contour.segments.add(new Segment(new Vector2(cursor), cursor.add(points[0]), cursor.add(points[1]), cursor.add(points[2])));
                        relativeControl = cursor.add(points[1]).subtract(cursor.add(points[2]));
                        cursor = cursor.add(points[2]);
                        continue block16;
                    }
                    case 's': {
                        Vector2 reflected = relativeControl.scale(-1.0);
                        Vector2 cp0 = cursor.add(reflected);
                        Vector2 cp1 = cursor.add(command.vector(0, 1));
                        Vector2 target = cursor.add(command.vector(2, 3));
                        contour.segments.add(new Segment(cursor.copy(), cp0, cp1, target));
                        cursor = target.copy();
                        relativeControl = cp1.subtract(target);
                        continue block16;
                    }
                    case 'S': {
                        Vector2 reflected = relativeControl.scale(-1.0);
                        Vector2 cp0 = cursor.add(reflected);
                        Vector2 cp1 = command.vector(0, 1);
                        Vector2 target = command.vector(2, 3);
                        contour.segments.add(new Segment(cursor.copy(), cp0, cp1, target));
                        cursor = target.copy();
                        relativeControl = cp1.subtract(target);
                        continue block16;
                    }
                    case 'Z': 
                    case 'z': {
                        if (cursor.subtract(anchor).length() >= 0.001) {
                            contour.segments.add(new Segment(cursor.copy(), anchor.copy()));
                        }
                        contour.closed = true;
                        continue block16;
                    }
                }
                throw new RuntimeException("op not implemented:" + command.op);
            }
            shape.contours.add(contour);
        }
        return shape;
    }
}

