/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.sketch;

import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.util.FPSAnimator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.nativewindow.util.DimensionImmutable;
import javax.media.opengl.GL;
import javax.media.opengl.GL3;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import net.lustlab.rndr.Configuration;
import net.lustlab.rndr.color.Color;
import net.lustlab.rndr.draw.DrawerGL3;

public class SketchGL3
implements GLEventListener,
MouseListener,
KeyListener {
    private static boolean ready = false;
    private static FPSAnimator animator;
    public Configuration configuration = new Configuration();
    public GLAutoDrawable drawable;
    public GL3 gl3;
    public long start = System.currentTimeMillis();
    public int width;
    public int height;
    public GLWindow window;
    public DrawerGL3 drawer;
    private boolean firstFrame = true;

    public void setup() {
    }

    public void draw() {
    }

    public double seconds() {
        return (double)(System.currentTimeMillis() - this.start) / 1000.0;
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseDragged(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mouseMoved(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
    }

    public void mouseReleased(MouseEvent event) {
    }

    public void mouseWheelMoved(MouseEvent event) {
    }

    public final void display(GLAutoDrawable drawable) {
        GL gl;
        if (!ready) {
            gl = drawable.getGL();
            gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            gl.glClear(17664);
        }
        if (this.firstFrame && ready) {
            this.drawable = drawable;
            this.width = this.configuration.width;
            this.height = this.configuration.height;
            gl = this.window.getGL().getGL3();
            this.gl3 = gl;
            this.drawer = new DrawerGL3(this.gl3, this.width, this.height);
            this.setup();
            this.start = System.currentTimeMillis();
            this.firstFrame = false;
        }
        if (ready) {
            this.width = this.configuration.width;
            this.height = this.configuration.height;
            gl = drawable.getGL().getGL3();
            this.gl3 = gl;
            this.draw();
        }
    }

    public final void dispose(GLAutoDrawable drawable) {
    }

    public final void init(GLAutoDrawable drawable) {
    }

    public final void reshape(GLAutoDrawable arg0, int arg1, int arg2, int arg3, int arg4) {
    }

    public final void background(Color color) {
        this.background(color.r, color.g, color.b, color.a);
    }

    public final void background(double r, double g, double b, double a) {
        GL gl = this.drawable.getGL();
        gl.glClearColor((float)r, (float)g, (float)b, (float)a);
        gl.glClear(17664);
    }

    public static final void run(SketchGL3 sketch) {
        SketchGL3.run(sketch, null);
    }

    public static final void run(SketchGL3 sketch, Configuration configuration) {
        GLWindow window;
        GLProfile glp = GLProfile.get((String)"GL3");
        GLCapabilities caps = new GLCapabilities(glp);
        caps.setHardwareAccelerated(true);
        caps.setDepthBits(24);
        caps.setStencilBits(8);
        sketch.window = window = GLWindow.create((GLCapabilitiesImmutable)caps);
        if (configuration == null) {
            configuration = sketch.configuration;
        }
        for (String logger : sketch.configuration.logLevels.keySet()) {
            String level = sketch.configuration.logLevels.get(logger);
            System.out.println("setting loglevel " + logger + " to " + Level.parse(level));
            Logger.getLogger(logger).setLevel(Level.parse(level));
        }
        window.setTitle(sketch.getClass().getName());
        window.setTitle(configuration.title);
        if (configuration.hideWindowDecorations) {
            window.setUndecorated(true);
        }
        window.addGLEventListener((GLEventListener)sketch);
        window.addMouseListener((MouseListener)sketch);
        window.addKeyListener((KeyListener)sketch);
        window.setVisible(true);
        if (configuration.width != -1 && configuration.height != -1) {
            window.setSize(configuration.width, configuration.height);
            window.setTopLevelPosition(configuration.left, configuration.top);
        } else {
            System.out.println("getting this fullscreen thing");
            MonitorDevice monitor = window.getMainMonitor();
            DimensionImmutable resolution = monitor.getCurrentMode().getSurfaceSize().getResolution();
            configuration.width = resolution.getWidth();
            configuration.height = resolution.getHeight();
            configuration.fullscreen = true;
        }
        window.setFullscreen(configuration.fullscreen);
        if (configuration.hideMouseCursor) {
            window.setPointerVisible(false);
        }
        animator = new FPSAnimator((GLAutoDrawable)window, configuration.fps, true);
        window.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowDestroyNotify(WindowEvent event) {
                new Thread(){

                    @Override
                    public void run() {
                        animator.stop();
                        System.exit(0);
                    }
                }.start();
            }
        });
        ready = true;
        animator.start();
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void quit() {
        animator.stop();
    }
}

