/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.shaders;

import java.util.HashMap;
import java.util.Map;
import javax.media.opengl.GL;
import net.lustlab.rndr.shaders.FragmentShader;
import net.lustlab.rndr.shaders.Shader;
import net.lustlab.rndr.shaders.ShaderDescriptor;
import net.lustlab.rndr.shaders.VertexShader;

public class ShaderManager {
    static final Map<ShaderDescriptor, Shader> shaders = new HashMap<ShaderDescriptor, Shader>();

    public static Shader shader(GL gl, String vertex, String fragment) {
        ShaderDescriptor descriptor = new ShaderDescriptor(vertex, fragment);
        Shader shader = shaders.get(descriptor);
        if (shader == null) {
            VertexShader vs = null;
            if (vertex != null) {
                vs = vertex.startsWith("/") ? VertexShader.load(gl, ShaderManager.class.getResourceAsStream(vertex)) : VertexShader.loadFromFile(gl, vertex);
            }
            FragmentShader fs = null;
            if (fragment != null) {
                fs = fragment.startsWith("/") ? FragmentShader.load(gl, ShaderManager.class.getResourceAsStream(fragment)) : FragmentShader.loadFromFile(gl, fragment);
            }
            shader = Shader.createShader(gl, vs, fs);
            shaders.put(descriptor, shader);
        }
        return shader;
    }
}

