/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.shaders;

import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GL2GL3;
import javax.media.opengl.GL3;
import net.lustlab.rndr.RNDRException;
import net.lustlab.rndr.color.Color;
import net.lustlab.rndr.gl.GLError;
import net.lustlab.rndr.math.Matrix44;
import net.lustlab.rndr.math.Vector2;
import net.lustlab.rndr.math.Vector3;
import net.lustlab.rndr.math.Vector4;
import net.lustlab.rndr.shaders.BlockBinding;
import net.lustlab.rndr.shaders.FragmentShader;
import net.lustlab.rndr.shaders.ShaderException;
import net.lustlab.rndr.shaders.ShaderInfo;
import net.lustlab.rndr.shaders.VertexShader;

public class Shader {
    Map<String, Integer> uniforms = new HashMap<String, Integer>();
    Map<String, Integer> attributes = new HashMap<String, Integer>();
    public final int program;
    public final GL gl;
    private boolean running;
    private GL2GL3 gl23;
    Set<String> issuedUniformWarnings = new HashSet<String>();

    public Shader(GL gl, int program) {
        this.program = program;
        this.gl = gl;
        this.gl23 = gl.getGL2GL3();
    }

    public static Shader createShader(GL gl, FragmentShader fragment) {
        return Shader.createShader(gl, null, fragment);
    }

    public static Shader createShader(GL gl, VertexShader vertex) {
        return Shader.createShader(gl, vertex, null);
    }

    public static Shader createShader(GL gl, VertexShader vertex, FragmentShader fragment) {
        if (gl.isGL2()) {
            GL2 gl2 = gl.getGL2();
            int program = gl2.glCreateProgramObjectARB();
            if (vertex != null) {
                gl2.glAttachObjectARB(program, vertex.shaderObject);
                ShaderInfo.checkShaderInfoLog(gl, program, "<unknown-vertex-shader>");
            }
            if (fragment != null) {
                gl2.glAttachObjectARB(program, fragment.shaderObject);
                ShaderInfo.checkShaderInfoLog(gl, program, "<unknown-fragment-shader>");
            }
            gl2.glLinkProgramARB(program);
            return new Shader(gl, program);
        }
        if (gl.isGL3()) {
            int status;
            GL3 gl3 = gl.getGL3();
            int error = gl3.glGetError();
            GLError.check((GL)gl3);
            int program = gl3.glCreateProgram();
            int[] count = new int[1];
            int[] names = new int[100];
            gl3.glGetAttachedShaders(program, 100, count, 0, names, 0);
            if (!gl3.glIsProgram(program)) {
                throw new ShaderException("that is no program");
            }
            if (vertex != null) {
                if (!gl3.glIsShader(vertex.shaderObject)) {
                    throw new ShaderException("that is no vertex shader object ");
                }
                gl3.glAttachShader(program, vertex.shaderObject);
                status = gl3.glGetError();
                if (status != 0) {
                    switch (status) {
                        case 1281: {
                            throw new ShaderException("Failed to attach vertex shader. GL_INVALID_VALUE. " + vertex.shaderObject);
                        }
                        case 1282: {
                            throw new ShaderException("Failed to attach vertex shader. GL_INVALID_OPERATION. " + vertex.shaderObject);
                        }
                    }
                }
            }
            if (fragment != null) {
                gl3.glAttachShader(program, fragment.shaderObject);
                status = gl3.glGetError();
                if (status != 0) {
                    throw new ShaderException("Failed to attach fragment shader.");
                }
            }
            gl3.glGetAttachedShaders(program, 100, count, 0, names, 0);
            gl3.glLinkProgram(program);
            int[] linkStatus = new int[1];
            gl3.glGetProgramiv(program, 35714, linkStatus, 0);
            ShaderInfo.checkProgramInfoLog(gl, program, "<unknown program>");
            GLError.check((GL)gl3);
            return new Shader(gl, program);
        }
        throw new RNDRException("unsupported GL implementation");
    }

    public void setUniform1f(String uniform, float u0) {
        int uniformIndex = this.uniformIndex(uniform);
        if (uniformIndex != -1) {
            this.gl23.glUniform1f(this.uniformIndex(uniform), u0);
        }
    }

    public void setUniform1d(String uniform, double u0) {
        int uniformIndex = this.uniformIndex(uniform);
        if (uniformIndex != -1) {
            this.gl23.glUniform1f(this.uniformIndex(uniform), (float)u0);
        }
    }

    public void setUniform2f(String uniform, float u0, float u1) {
        if (this.uniformIndex(uniform) != -1) {
            this.gl23.glUniform2f(this.uniformIndex(uniform), u0, u1);
        }
    }

    public void setUniform(String uniform, Vector4[] vector4s) {
        if (this.uniformIndex(uniform) != -1) {
            FloatBuffer buffer = FloatBuffer.allocate(16 * vector4s.length);
            for (Vector4 v : vector4s) {
                buffer.put((float)v.x).put((float)v.y).put((float)v.z).put((float)v.w);
            }
            buffer.rewind();
            this.gl23.glUniform4fv(this.uniformIndex(uniform), vector4s.length, buffer);
        }
    }

    public void setUniform(String uniform, Vector3[] vector3s) {
        if (this.uniformIndex(uniform) != -1) {
            FloatBuffer buffer = FloatBuffer.allocate(12 * vector3s.length);
            for (Vector3 v : vector3s) {
                buffer.put((float)v.x).put((float)v.y).put((float)v.z);
            }
            buffer.rewind();
            this.gl23.glUniform3fv(this.uniformIndex(uniform), vector3s.length, buffer);
        }
    }

    public void setUniform(String uniform, Vector2[] vector2s) {
        if (this.uniformIndex(uniform) != -1) {
            FloatBuffer buffer = FloatBuffer.allocate(8 * vector2s.length);
            for (Vector2 v : vector2s) {
                buffer.put((float)v.x).put((float)v.y);
            }
            buffer.rewind();
            this.gl23.glUniform2fv(this.uniformIndex(uniform), vector2s.length, buffer);
        }
    }

    public void setUniform(String uniform, float[] floats) {
        if (this.uniformIndex(uniform) != -1) {
            FloatBuffer buffer = FloatBuffer.allocate(4 * floats.length);
            for (float f : floats) {
                buffer.put(f);
            }
            buffer.rewind();
            this.gl23.glUniform1fv(this.uniformIndex(uniform), floats.length, buffer);
        }
    }

    public void setUniform3f(String uniform, float u0, float u1, float u2) {
        if (this.uniformIndex(uniform) != -1) {
            this.gl23.glUniform3f(this.uniformIndex(uniform), u0, u1, u2);
        }
    }

    public void setUniform1i(String uniform, int u0) {
        if (this.uniformIndex(uniform) != -1) {
            this.gl23.glUniform1i(this.uniformIndex(uniform), u0);
        }
    }

    public int blockIndex(String block) {
        return this.gl23.glGetUniformBlockIndex(this.program, block);
    }

    public Shader bindBlock(String block, BlockBinding blockBinding) {
        int blockIndex = this.blockIndex(block);
        if (blockIndex != -1) {
            this.gl23.glUniformBlockBinding(this.program, blockIndex, blockBinding.name);
        }
        return this;
    }

    public int uniformIndex(String uniform) {
        Integer loc = this.uniforms.get(uniform);
        if (loc == null) {
            int location = this.gl23.glGetUniformLocation(this.program, uniform);
            if (location == -1) {
                // empty if block
            }
            this.uniforms.put(uniform, location);
            loc = location;
        }
        return loc;
    }

    public int attributeIndex(String attribute) {
        Integer loc = this.attributes.get(attribute);
        if (loc == null) {
            int location = this.gl23.glGetAttribLocation(this.program, attribute);
            if (location == -1) {
                // empty if block
            }
            this.attributes.put(attribute, location);
            loc = location;
        }
        return loc;
    }

    public void setUniform(String uniform, Matrix44 matrix) {
        FloatBuffer fb = FloatBuffer.allocate(16);
        fb.rewind();
        matrix.toFloatBuffer(fb);
        fb.rewind();
        if (this.uniformIndex(uniform) != -1) {
            this.gl23.glUniformMatrix4fv(this.uniformIndex(uniform), 1, true, fb);
        } else if (!this.issuedUniformWarnings.contains(uniform)) {
            System.err.println("problem with uniform:" + uniform);
            this.issuedUniformWarnings.add(uniform);
        }
    }

    public void setUniform4f(String uniform, float u0, float u1, float u2, float u3) {
        int uniformIndex = this.uniformIndex(uniform);
        if (uniformIndex != -1) {
            this.gl23.glUniform4f(uniformIndex, u0, u1, u2, u3);
        }
    }

    public void setUniform(String uniform, Vector2 v) {
        this.setUniform2f(uniform, (float)v.x, (float)v.y);
    }

    public void setUniform(String uniform, Vector3 v) {
        this.setUniform3f(uniform, (float)v.x, (float)v.y, (float)v.z);
    }

    public void setUniform(String uniform, Vector4 v) {
        this.setUniform4f(uniform, (float)v.x, (float)v.y, (float)v.z, (float)v.w);
    }

    public void setUniform(String uniform, Color c) {
        this.setUniform4f(uniform, (float)c.r, (float)c.g, (float)c.b, (float)c.a);
    }

    public void begin() {
        if (this.running) {
            throw new ShaderException("Shader is already in use");
        }
        if (this.gl.isGL2()) {
            this.gl.getGL2().glUseProgramObjectARB(this.program);
        } else if (this.gl.isGL3()) {
            this.gl.getGL3().glUseProgram(this.program);
        }
        this.running = true;
    }

    public void end() {
        if (!this.running) {
            throw new ShaderException("Shader is not in use");
        }
        if (this.gl.isGL2()) {
            this.gl.getGL2().glUseProgramObjectARB(0);
        } else if (this.gl.isGL3()) {
            this.gl.getGL3().glUseProgram(0);
        }
        this.running = false;
    }

    public void setUniform(String uniform, boolean value) {
        int uniformIndex = this.uniformIndex(uniform);
        if (uniformIndex != -1) {
            this.gl23.glUniform1i(uniformIndex, value ? 1 : 0);
        }
    }
}

