/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.shaders;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import net.lustlab.rndr.RNDRException;
import net.lustlab.rndr.shaders.ShaderException;
import net.lustlab.rndr.shaders.ShaderInfo;
import org.apache.commons.io.IOUtils;

public class GeometryShader {
    public final int shaderObject;

    public GeometryShader(int shaderObject) {
        this.shaderObject = shaderObject;
    }

    public static GeometryShader loadFromString(GL gl, String code) {
        GL2 gl2 = gl.getGL2();
        int shaderObject = gl2.glCreateShaderObjectARB(36313);
        gl2.glShaderSource(shaderObject, 1, new String[]{code}, null, 0);
        gl2.glCompileShader(shaderObject);
        int[] values = new int[1];
        gl2.glGetShaderiv(shaderObject, 35713, values, 0);
        if (values[0] != 1) {
            ShaderInfo.checkShaderInfoLog(gl, shaderObject, "<unknown-geometry-shader>");
        }
        return new GeometryShader(shaderObject);
    }

    public static GeometryShader loadFromFile(GL gl, String filename) {
        return GeometryShader.loadFromFile(gl, new File(filename));
    }

    public static GeometryShader loadFromFile(GL gl, File file) {
        try {
            FileInputStream stream = new FileInputStream(file);
            return GeometryShader.load(gl, stream);
        }
        catch (FileNotFoundException e) {
            throw new ShaderException("Shader file not found: " + file.getName());
        }
    }

    public static GeometryShader load(GL gl, InputStream stream) {
        StringWriter writer = new StringWriter();
        try {
            IOUtils.copy((InputStream)stream, (Writer)writer, (String)"utf-8");
            String code = writer.toString();
            GeometryShader geometryShader = GeometryShader.loadFromString(gl, code);
            return geometryShader;
        }
        catch (IOException e) {
            throw new ShaderException("Error reading from shader stream: " + e.getMessage());
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RNDRException(e);
            }
        }
    }
}

