/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.shaders;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GL3;
import net.lustlab.rndr.RNDRException;
import net.lustlab.rndr.shaders.ShaderException;
import net.lustlab.rndr.shaders.ShaderInfo;
import org.apache.commons.io.IOUtils;

public class FragmentShader {
    public final int shaderObject;

    public FragmentShader(int shaderObject) {
        this.shaderObject = shaderObject;
    }

    public static FragmentShader loadFromString(GL gl, String code) {
        if (gl.isGL2()) {
            GL2 gl2 = gl.getGL2();
            int shaderObject = gl2.glCreateShaderObjectARB(35632);
            gl2.glShaderSource(shaderObject, 1, new String[]{code}, null, 0);
            gl2.glCompileShader(shaderObject);
            int[] values = new int[1];
            gl2.glGetShaderiv(shaderObject, 35713, values, 0);
            if (values[0] != 1) {
                ShaderInfo.checkShaderInfoLog(gl, shaderObject, "<unknown-fragment-shader>");
            }
            return new FragmentShader(shaderObject);
        }
        if (gl.isGL3()) {
            GL3 gl3 = gl.getGL3();
            int shaderObject = gl3.glCreateShader(35632);
            gl3.glShaderSource(shaderObject, 1, new String[]{code}, null, 0);
            gl3.glCompileShader(shaderObject);
            int[] values = new int[1];
            gl3.glGetShaderiv(shaderObject, 35713, values, 0);
            if (values[0] != 1) {
                ShaderInfo.checkShaderInfoLog(gl, shaderObject, "<unknown-fragment-shader>");
            }
            return new FragmentShader(shaderObject);
        }
        throw new RNDRException("unsupported GL implementation");
    }

    public static FragmentShader loadFromFile(GL gl, String filename) {
        return FragmentShader.loadFromFile(gl, new File(filename));
    }

    public static FragmentShader loadFromFile(GL gl, File file) {
        try {
            FileInputStream stream = new FileInputStream(file);
            return FragmentShader.load(gl, stream);
        }
        catch (FileNotFoundException e) {
            throw new ShaderException("Shader file not found: " + file.getName());
        }
    }

    public static FragmentShader load(GL gl, InputStream stream) {
        StringWriter writer = new StringWriter();
        try {
            IOUtils.copy((InputStream)stream, (Writer)writer, (String)"utf-8");
            String code = writer.toString();
            FragmentShader fragmentShader = FragmentShader.loadFromString(gl, code);
            return fragmentShader;
        }
        catch (IOException e) {
            throw new ShaderException("Error reading from shader stream: " + e.getMessage());
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RNDRException(e);
            }
        }
    }
}

