/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.post;

import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureIO;
import java.io.IOException;
import java.io.InputStream;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GLException;
import net.lustlab.rndr.RNDRException;
import net.lustlab.rndr.fbo.FBO;
import net.lustlab.rndr.post.Grayscale;
import net.lustlab.rndr.post.PostProcessor;
import net.lustlab.rndr.shaders.FragmentShader;
import net.lustlab.rndr.shaders.Shader;
import net.lustlab.rndr.shaders.VertexShader;

public class Hipstergraph
extends PostProcessor {
    Texture noiseTexture;
    Shader blurShader;
    Shader combineShader;
    FBO[] tempFBOs;
    final int width;
    final int height;

    public Hipstergraph(GL gl, int width, int height) {
        try {
            this.noiseTexture = TextureIO.newTexture((InputStream)Hipstergraph.class.getResourceAsStream("/textures/noise-gaussian.png"), (boolean)true, (String)"png");
            this.noiseTexture.setTexParameterf(gl, 10242, 10497.0f);
            this.noiseTexture.setTexParameterf(gl, 10243, 10497.0f);
        }
        catch (IOException | GLException e) {
            throw new RNDRException((Exception)e);
        }
        this.width = width;
        this.height = height;
        FragmentShader frag = FragmentShader.load(gl, Grayscale.class.getResourceAsStream("/shaders/post_hipstergraph.frag"));
        VertexShader vert = VertexShader.load(gl, Grayscale.class.getResourceAsStream("/shaders/post_common.vert"));
        this.shader = Shader.createShader(gl, vert, frag);
        this.blurShader = Shader.createShader(gl, vert, FragmentShader.load(gl, Hipstergraph.class.getResourceAsStream("/shaders/post_blur.frag")));
        this.combineShader = Shader.createShader(gl, vert, FragmentShader.load(gl, Hipstergraph.class.getResourceAsStream("/shaders/post_blur-combine.frag")));
        this.tempFBOs = new FBO[2];
        this.tempFBOs[0] = new FBO(gl, width, height, 0);
        this.tempFBOs[1] = new FBO(gl, width, height, 0);
    }

    @Override
    public void render(GL gl, FBO fbo, FBO target) {
        int window = 15;
        this.tempFBOs[0].bindTarget();
        GL2 gl2 = gl.getGL2();
        gl2.glClear(16640);
        this.shader.begin();
        this.shader.setUniform1i("texture", 0);
        this.shader.setUniform1i("texture1", 1);
        float u0 = 0.0f;
        float u1 = 1.0f;
        float v0 = 0.0f;
        float v1 = 1.0f;
        float noiseX = (float)Math.random();
        float noiseY = (float)Math.random();
        float noiseWidth = (float)fbo.width() * 1.0f / (float)this.noiseTexture.getWidth();
        float noiseHeight = (float)fbo.height() * 1.0f / (float)this.noiseTexture.getHeight();
        float noiseU0 = noiseX;
        float noiseU1 = noiseX + noiseWidth * 8.0f;
        float noiseV0 = noiseY;
        float noiseV1 = noiseY + noiseHeight * 8.0f;
        gl2.glActiveTexture(33984);
        fbo.bindTexture();
        gl2.glActiveTexture(33985);
        this.noiseTexture.bind((GL)gl2);
        gl2.glEnable(3553);
        gl2.glBegin(7);
        gl2.glColor4d(1.0, 1.0, 1.0, 1.0);
        gl2.glMultiTexCoord2f(33984, u0, v0);
        gl2.glMultiTexCoord2f(33985, noiseU0, noiseV0);
        gl2.glVertex2f(-1.0f, -1.0f);
        gl2.glMultiTexCoord2f(33984, u1, v0);
        gl2.glMultiTexCoord2f(33985, noiseU1, noiseV0);
        gl2.glVertex2f(1.0f, -1.0f);
        gl2.glMultiTexCoord2f(33984, u1, v1);
        gl2.glMultiTexCoord2f(33985, noiseU1, noiseV1);
        gl2.glVertex2f(1.0f, 1.0f);
        gl2.glMultiTexCoord2f(33984, u0, v1);
        gl2.glMultiTexCoord2f(33985, noiseU0, noiseV1);
        gl2.glVertex2f(-1.0f, 1.0f);
        gl2.glEnd();
        gl2.glDisable(3553);
        gl2.glBindTexture(3553, 0);
        this.shader.end();
        gl2.glActiveTexture(33985);
        gl2.glBindTexture(3553, 0);
        gl2.glActiveTexture(33984);
        gl2.glBindTexture(3553, 0);
        this.tempFBOs[0].unbindTarget();
        this.tempFBOs[0].bindTexture();
        this.tempFBOs[1].bindTarget();
        gl2.glClearColor(0.0f, 1.0f, 0.0f, 1.0f);
        gl2.glClear(16640);
        gl2.glEnable(3553);
        this.blurShader.begin();
        this.blurShader.setUniform1i("texture", 0);
        this.blurShader.setUniform1i("window", window);
        this.blurShader.setUniform2f("blurDirection", 1.0f / (float)fbo.width(), 1.0f / (float)fbo.height());
        gl2.glBegin(7);
        gl2.glColor4d(1.0, 1.0, 1.0, 1.0);
        gl2.glMultiTexCoord2f(33984, u0, v0);
        gl2.glVertex2f(-1.0f, -1.0f);
        gl2.glMultiTexCoord2f(33984, u1, v0);
        gl2.glVertex2f(1.0f, -1.0f);
        gl2.glMultiTexCoord2f(33984, u1, v1);
        gl2.glVertex2f(1.0f, 1.0f);
        gl2.glMultiTexCoord2f(33984, u0, v1);
        gl2.glVertex2f(-1.0f, 1.0f);
        gl2.glEnd();
        this.blurShader.end();
        this.tempFBOs[1].unbindTarget();
        this.tempFBOs[1].bindTexture();
        this.tempFBOs[0].bindTarget();
        gl2.glEnable(3553);
        this.blurShader.begin();
        this.blurShader.setUniform1i("texture", 0);
        this.blurShader.setUniform1i("window", window);
        this.blurShader.setUniform2f("blurDirection", 1.0f / (float)fbo.width(), -1.0f / (float)fbo.height());
        gl2.glBegin(7);
        gl2.glColor4d(1.0, 1.0, 1.0, 1.0);
        gl2.glMultiTexCoord2f(33984, u0, v0);
        gl2.glVertex2f(-1.0f, -1.0f);
        gl2.glMultiTexCoord2f(33984, u1, v0);
        gl2.glVertex2f(1.0f, -1.0f);
        gl2.glMultiTexCoord2f(33984, u1, v1);
        gl2.glVertex2f(1.0f, 1.0f);
        gl2.glMultiTexCoord2f(33984, u0, v1);
        gl2.glVertex2f(-1.0f, 1.0f);
        gl2.glEnd();
        this.blurShader.end();
        this.tempFBOs[1].unbindTexture();
        this.tempFBOs[0].unbindTarget();
        this.tempFBOs[0].bindTexture();
        this.tempFBOs[1].bindTarget();
        gl2.glClearColor(0.0f, 1.0f, 0.0f, 1.0f);
        gl2.glClear(16640);
        gl2.glEnable(3553);
        this.blurShader.begin();
        this.blurShader.setUniform1i("texture", 0);
        this.blurShader.setUniform1i("window", window);
        this.blurShader.setUniform2f("blurDirection", 0.0f, 1.0f / (float)fbo.height());
        gl2.glBegin(7);
        gl2.glColor4d(1.0, 1.0, 1.0, 1.0);
        gl2.glMultiTexCoord2f(33984, u0, v0);
        gl2.glVertex2f(-1.0f, -1.0f);
        gl2.glMultiTexCoord2f(33984, u1, v0);
        gl2.glVertex2f(1.0f, -1.0f);
        gl2.glMultiTexCoord2f(33984, u1, v1);
        gl2.glVertex2f(1.0f, 1.0f);
        gl2.glMultiTexCoord2f(33984, u0, v1);
        gl2.glVertex2f(-1.0f, 1.0f);
        gl2.glEnd();
        this.blurShader.end();
        this.tempFBOs[1].unbindTarget();
        this.tempFBOs[1].bindTexture();
        this.tempFBOs[0].bindTarget();
        gl2.glEnable(3553);
        this.blurShader.begin();
        this.blurShader.setUniform1i("texture", 0);
        this.blurShader.setUniform1i("window", window);
        this.blurShader.setUniform2f("blurDirection", 1.0f / (float)fbo.width(), 0.0f);
        gl2.glBegin(7);
        gl2.glColor4d(1.0, 1.0, 1.0, 1.0);
        gl2.glMultiTexCoord2f(33984, u0, v0);
        gl2.glVertex2f(-1.0f, -1.0f);
        gl2.glMultiTexCoord2f(33984, u1, v0);
        gl2.glVertex2f(1.0f, -1.0f);
        gl2.glMultiTexCoord2f(33984, u1, v1);
        gl2.glVertex2f(1.0f, 1.0f);
        gl2.glMultiTexCoord2f(33984, u0, v1);
        gl2.glVertex2f(-1.0f, 1.0f);
        gl2.glEnd();
        this.blurShader.end();
        this.tempFBOs[1].unbindTexture();
        this.tempFBOs[0].unbindTarget();
        gl2.glActiveTexture(33984);
        fbo.bindTexture();
        gl2.glActiveTexture(33985);
        this.tempFBOs[0].bindTexture();
        this.combineShader.begin();
        this.combineShader.setUniform1i("texture", 0);
        this.combineShader.setUniform1i("texture1", 1);
        if (target != null) {
            target.bindTarget();
        }
        gl2.glBegin(7);
        gl2.glColor4d(1.0, 1.0, 1.0, 1.0);
        gl2.glMultiTexCoord2f(33984, u0, v0);
        gl2.glVertex2f(-1.0f, -1.0f);
        gl2.glMultiTexCoord2f(33984, u1, v0);
        gl2.glVertex2f(1.0f, -1.0f);
        gl2.glMultiTexCoord2f(33984, u1, v1);
        gl2.glVertex2f(1.0f, 1.0f);
        gl2.glMultiTexCoord2f(33984, u0, v1);
        gl2.glVertex2f(-1.0f, 1.0f);
        gl2.glEnd();
        this.combineShader.end();
        gl2.glActiveTexture(33985);
        this.tempFBOs[0].unbindTexture();
        gl2.glActiveTexture(33984);
        fbo.unbindTexture();
        if (target != null) {
            target.unbindTarget();
        }
    }
}

