/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.noise;

import java.util.ArrayList;
import java.util.Collections;

public class PerlinNoise {
    final int permSize = 8192;
    int[] P;
    double[] G;

    public double grad(int hash, double x, double y, double z) {
        double u;
        int h = hash & 0xF;
        double d = u = h < 8 ? x : y;
        double v = h < 4 ? y : (h == 12 || h == 14 ? x : z);
        return ((h & 1) == 0 ? u : -u) + ((h & 2) == 0 ? v : -v);
    }

    public PerlinNoise() {
        int i;
        ArrayList<Integer> p = new ArrayList<Integer>();
        for (i = 0; i < 8192; ++i) {
            p.add(i);
        }
        Collections.shuffle(p);
        this.P = new int[8192];
        this.G = new double[8192];
        for (i = 0; i < 8192; ++i) {
            this.P[i] = (Integer)p.get(i);
            this.G[i] = Math.random() * 2.0 - 1.0;
        }
    }

    public double[] dnoise(double[] vout, double x, double y, double z, double weight) {
        if (vout == null) {
            vout = new double[4];
        }
        int i = (int)x;
        int j = (int)y;
        int k = (int)z;
        double u = x - (double)i;
        double v = y - (double)j;
        double w = z - (double)k;
        double du = 30.0 * u * u * (u * (u - 2.0) + 1.0);
        double dv = 30.0 * v * v * (v * (v - 2.0) + 1.0);
        double dw = 30.0 * w * w * (w * (w - 2.0) + 1.0);
        u = u * u * u * (u * (u * 6.0 - 15.0) + 10.0);
        v = v * v * v * (v * (v * 6.0 - 15.0) + 10.0);
        w = w * w * w * (w * (w * 6.0 - 15.0) + 10.0);
        int A = this.P[i % 8192] + j;
        int AA = this.P[A % 8192] + k;
        int AB = this.P[(A + 1) % 8192] + k;
        int B = this.P[(i + 1) % 8192] + j;
        int BA = this.P[B % 8192] + k;
        int BB = this.P[(B + 1) % 8192] + k;
        double a = this.grad(this.P[AA % 8192], u, v, w);
        double b = this.grad(this.P[BA % 8192], u - 1.0, v, w);
        double c = this.grad(this.P[AB % 8192], u, v - 1.0, w);
        double d = this.grad(this.P[BB % 8192], u - 1.0, v - 1.0, w);
        double e = this.grad(this.P[(AA + 1) % 8192], u, v, w - 1.0);
        double f = this.grad(this.P[(BA + 1) % 8192], u - 1.0, v, w - 1.0);
        double g = this.grad(this.P[(AB + 1) % 8192], u, v - 1.0, w - 1.0);
        double h = this.grad(this.P[(BB + 1) % 8192], u - 1.0, v - 1.0, w - 1.0);
        double k0 = a;
        double k1 = b - a;
        double k2 = c - a;
        double k3 = e - a;
        double k4 = a - b - c + d;
        double k5 = a - c - e + g;
        double k6 = a - b - e + f;
        double k7 = -a + b + c - d + e - f - g + h;
        vout[0] = vout[0] + (k0 + k1 * u + k2 * v + k3 * w + k4 * u * v + k5 * v * w + k6 * w * u + k7 * u * v * w) * weight;
        vout[1] = vout[1] + du * (k1 + k4 * v + k6 * w + k7 * v * w) * weight;
        vout[2] = vout[2] + dv * (k2 + k5 * w + k4 * u + k7 * w * u) * weight;
        vout[3] = vout[3] + dw * (k3 + k6 * u + k5 * v + k7 * u * v) * weight;
        return vout;
    }

    public double[] dbrown(double x, double y, double z, int octaves) {
        double[] vout = new double[4];
        double weight = 1.0;
        for (int octave = 0; octave < octaves; ++octave) {
            this.dnoise(vout, x, y, z, weight);
            x *= 2.0;
            y *= 2.0;
            z *= 2.0;
            weight *= 0.5;
        }
        return vout;
    }
}

