/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.math;

import java.io.Serializable;
import net.lustlab.rndr.math.Matrix44;

public class Vector3
implements Serializable {
    public static Vector3 Zero = new Vector3();
    public static Vector3 UnitX = new Vector3(1.0, 0.0, 0.0);
    public static Vector3 UnitY = new Vector3(0.0, 1.0, 0.0);
    public static Vector3 UnitZ = new Vector3(0.0, 0.0, 1.0);
    public double x;
    public double y;
    public double z;

    public Vector3() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public Vector3(double[] v) {
        this.x = v[0];
        this.y = v[1];
        this.z = v[2];
    }

    public Vector3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3(double v) {
        this.x = v;
        this.y = v;
        this.z = v;
    }

    public Vector3 multiply(Matrix44 m) {
        return new Vector3(this.x * m.m00 + this.y * m.m10 + this.z * m.m20 + m.m30, this.x * m.m01 + this.y * m.m11 + this.z * m.m21 + m.m31, this.x * m.m02 + this.y * m.m12 + this.z * m.m22 + m.m32);
    }

    public Vector3 cross(Vector3 v) {
        return new Vector3(this.y * v.z - this.z * v.y, -(this.x * v.z - this.z * v.x), this.x * v.y - this.y * v.x);
    }

    public double[] array() {
        return new double[]{this.x, this.y, this.z, 0.0, 0.0, 0.0};
    }

    public double squaredLength() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public Vector3 scale(double s) {
        return new Vector3(this.x * s, this.y * s, this.z * s);
    }

    public Vector3 scale(double xs, double ys, double zs) {
        return new Vector3(this.x * xs, this.y * ys, this.z * zs);
    }

    public Vector3 add(Vector3 other) {
        return new Vector3(this.x + other.x, this.y + other.y, this.z + other.z);
    }

    public Vector3 subtract(Vector3 other) {
        return new Vector3(this.x - other.x, this.y - other.y, this.z - other.z);
    }

    public Vector3 mask(Vector3 other) {
        return new Vector3(this.x * other.x, this.y * other.y, this.z * other.z);
    }

    public double dot(Vector3 other) {
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    public Vector3 normalized() {
        double l = this.length();
        if (l == 0.0) {
            l = 1.0;
        }
        return new Vector3(this.x / l, this.y / l, this.z / l);
    }

    public String toString() {
        return "Vector3{x=" + this.x + ", y=" + this.y + ", z=" + this.z + '}';
    }
}

