/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.math;

import net.lustlab.rndr.math.Matrix33;
import net.lustlab.rndr.math.Matrix44;
import net.lustlab.rndr.math.Vector3;
import net.lustlab.rndr.math.Vector4;

public class Transforms {
    public static Matrix44 normal(Matrix44 m) {
        Matrix33 mu = new Matrix33(m.m00, m.m10, m.m20, m.m01, m.m11, m.m21, m.m02, m.m12, m.m22);
        Matrix33 muit = mu.inverse().transpose();
        Matrix44 n = new Matrix44(muit.m00, muit.m10, muit.m20, 0.0, muit.m01, muit.m11, muit.m21, 0.0, muit.m02, muit.m12, muit.m22, 0.0, 0.0, 0.0, 0.0, 0.0);
        return n;
    }

    public static Matrix44 ortho(double left, double right, double bottom, double top, double near, double far) {
        double tx = -(right + left) / (right - left);
        double ty = -(top + bottom) / (top - bottom);
        double tz = -(far + near) / (far - near);
        return new Matrix44(2.0 / (right - left), 0.0, 0.0, tx, 0.0, 2.0 / (top - bottom), 0.0, ty, 0.0, 0.0, -2.0 / (far - near), tz, 0.0, 0.0, 0.0, 1.0);
    }

    public static Matrix44 frustum(double left, double right, double bottom, double top, double near, double far) {
        double a = (right + left) / (right - left);
        double b = (top + bottom) / (top - bottom);
        double c = -(far + near) / (far - near);
        double d = -(2.0 * far * near) / (far - near);
        return new Matrix44(2.0 * near / (right - left), 0.0, a, 0.0, 0.0, 2.0 * near / (top - bottom), b, 0.0, 0.0, 0.0, c, d, 0.0, 0.0, -1.0, 0.0);
    }

    public static Matrix44 perspective(double fovy, double aspect, double near, double far) {
        double fH = Math.tan(fovy / 360.0 * Math.PI) * near;
        double fW = fH * aspect;
        return Transforms.frustum(-fW, fW, -fH, fH, near, far);
    }

    public static Matrix44 translate(Vector3 translation) {
        Matrix44 m = new Matrix44(Vector4.UnitX, Vector4.UnitY, Vector4.UnitZ, new Vector4(translation.x, translation.y, translation.z, 1.0));
        return m;
    }

    public static Matrix44 lookAt(Vector3 eye, Vector3 center, Vector3 up) {
        up = up.normalized();
        Vector3 za = center.subtract(eye).normalized();
        Vector3 xa = up.cross(za).normalized();
        Vector3 ya = za.cross(xa).normalized();
        Vector3 re = eye.scale(-1.0);
        Matrix44 t = new Matrix44(1.0, 0.0, 0.0, re.x, 0.0, 1.0, 0.0, re.y, 0.0, 0.0, 1.0, re.z, 0.0, 0.0, 0.0, 1.0);
        Matrix44 m = new Matrix44(xa.x, ya.x, -za.x, 0.0, xa.y, ya.y, -za.y, 0.0, xa.z, ya.z, -za.z, 0.0, 0.0, 0.0, 0.0, 1.0).transpose();
        return m.multiply(t);
    }

    public static Matrix44 scale(double s) {
        return new Matrix44(s, 0.0, 0.0, 0.0, 0.0, s, 0.0, 0.0, 0.0, 0.0, s, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    public static Matrix44 rotate(Vector3 axis, double r) {
        double cr = Math.cos(r);
        double sr = Math.sin(r);
        double ux = axis.x;
        double uy = axis.y;
        double uz = axis.z;
        Vector3 c0 = new Vector3(cr + axis.x * axis.x * (1.0 - cr), axis.y * axis.x * (1.0 - cr) + axis.z * sr, axis.z * axis.x * (1.0 - cr) - axis.y * sr);
        Vector3 c1 = new Vector3(ux * uy * (1.0 - cr) - uz * sr, cr + uy * uy * (1.0 - cr), uz * uy * (1.0 - cr) + ux * sr);
        Vector3 c2 = new Vector3(ux * uz * (1.0 - cr) + uy * sr, uy * uz * (1.0 - cr) - ux * sr, cr + uz * uz * (1.0 - cr));
        return new Matrix44(c0, c1, c2, Vector3.Zero);
    }

    public static Matrix44 rotateX(double r) {
        double cr = Math.cos(r);
        double sr = Math.sin(r);
        return new Matrix44(1.0, 0.0, 0.0, 0.0, 0.0, cr, -sr, 0.0, 0.0, sr, cr, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    public static Matrix44 rotateY(double r) {
        double cr = Math.cos(r);
        double sr = Math.sin(r);
        return new Matrix44(cr, 0.0, sr, 0.0, 0.0, 1.0, 0.0, 0.0, -sr, 0.0, cr, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    public static Matrix44 rotateZ(double r) {
        double cr = Math.cos(r);
        double sr = Math.sin(r);
        return new Matrix44(cr, -sr, 0.0, 0.0, sr, cr, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
    }
}

