/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.math;

import java.util.Stack;
import net.lustlab.rndr.math.Matrix44;
import net.lustlab.rndr.math.Transforms;
import net.lustlab.rndr.math.Vector3;

public class Transform {
    public final Matrix44 matrix;
    public static final Transform Identity = new Transform();
    private final Stack<Matrix44> stack;
    private static final Stack<Matrix44> EmptyStack = new Stack();

    public Transform push() {
        Stack newStack = this.stack == null ? new Stack() : (Stack)this.stack.clone();
        newStack.push(this.matrix);
        return new Transform(this.matrix, newStack);
    }

    public Transform pop() {
        Stack newStack = this.stack == null ? new Stack() : (Stack)this.stack.clone();
        Matrix44 matrix = (Matrix44)newStack.pop();
        return new Transform(matrix, newStack);
    }

    public Transform() {
        this.matrix = Matrix44.Identity;
        this.stack = EmptyStack;
    }

    public Transform(Transform t) {
        this.matrix = new Matrix44(t.matrix);
        this.stack = EmptyStack;
    }

    public Transform(Matrix44 matrix) {
        this.matrix = matrix;
        this.stack = EmptyStack;
    }

    public Transform(Matrix44 matrix, Stack<Matrix44> stack) {
        this.matrix = matrix;
        this.stack = stack != null ? (Stack)stack.clone() : null;
    }

    public Transform transform(Transform transform) {
        return new Transform(transform.matrix.multiply(this.matrix), this.stack);
    }

    public Transform translate(double x, double y) {
        Matrix44 translation = Transforms.translate(new Vector3(x, y, 0.0));
        return new Transform(translation.multiply(this.matrix), this.stack);
    }

    public Transform translate(double x, double y, double z) {
        Matrix44 translation = Transforms.translate(new Vector3(x, y, z));
        return new Transform(translation.multiply(this.matrix), this.stack);
    }

    public Transform translate(Vector3 offset) {
        Matrix44 translation = Transforms.translate(offset);
        return new Transform(translation.multiply(this.matrix), this.stack);
    }

    public Transform rotate(double r) {
        return this.rotateZ(r);
    }

    public Transform rotateZ(double r) {
        Matrix44 rotation = Transforms.rotateZ(r);
        return new Transform(rotation.multiply(this.matrix), this.stack);
    }

    public Transform rotateY(double r) {
        Matrix44 rotation = Transforms.rotateY(r);
        return new Transform(rotation.multiply(this.matrix), this.stack);
    }

    public Transform rotateX(double r) {
        Matrix44 rotation = Transforms.rotateX(r);
        return new Transform(rotation.multiply(this.matrix), this.stack);
    }

    public Transform scale(double s) {
        Matrix44 scale = new Matrix44(s, s, s, 1.0);
        return new Transform(scale.multiply(this.matrix), this.stack);
    }

    public Transform scale(double sx, double sy, double sz) {
        Matrix44 scale = new Matrix44(sx, sy, sz, 1.0);
        return new Transform(scale.multiply(this.matrix), this.stack);
    }
}

