/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.math;

import java.nio.FloatBuffer;
import net.lustlab.rndr.math.Vector3;
import net.lustlab.rndr.math.Vector4;

public class Matrix44 {
    public final double m00;
    public final double m10;
    public final double m20;
    public final double m30;
    public final double m01;
    public final double m11;
    public final double m21;
    public final double m31;
    public final double m02;
    public final double m12;
    public final double m22;
    public final double m32;
    public final double m03;
    public final double m13;
    public final double m23;
    public final double m33;
    public static final Matrix44 Identity = new Matrix44(1.0);

    public Matrix44() {
        this.m30 = 0.0;
        this.m20 = 0.0;
        this.m10 = 0.0;
        this.m00 = 0.0;
        this.m31 = 0.0;
        this.m21 = 0.0;
        this.m11 = 0.0;
        this.m01 = 0.0;
        this.m32 = 0.0;
        this.m22 = 0.0;
        this.m12 = 0.0;
        this.m02 = 0.0;
        this.m33 = 0.0;
        this.m23 = 0.0;
        this.m13 = 0.0;
        this.m03 = 0.0;
    }

    public Matrix44(double diagonalValue) {
        this.m22 = this.m33 = diagonalValue;
        this.m11 = this.m33;
        this.m00 = this.m33;
        this.m03 = 0.0;
        this.m02 = 0.0;
        this.m01 = 0.0;
        this.m13 = 0.0;
        this.m12 = 0.0;
        this.m10 = 0.0;
        this.m23 = 0.0;
        this.m21 = 0.0;
        this.m20 = 0.0;
        this.m32 = 0.0;
        this.m31 = 0.0;
        this.m30 = 0.0;
    }

    public Matrix44(double dv0, double dv1, double dv2, double dv3) {
        this.m00 = dv0;
        this.m11 = dv1;
        this.m22 = dv2;
        this.m33 = dv3;
        this.m03 = 0.0;
        this.m02 = 0.0;
        this.m01 = 0.0;
        this.m13 = 0.0;
        this.m12 = 0.0;
        this.m10 = 0.0;
        this.m23 = 0.0;
        this.m21 = 0.0;
        this.m20 = 0.0;
        this.m32 = 0.0;
        this.m31 = 0.0;
        this.m30 = 0.0;
    }

    public Matrix44(Vector3 col0, Vector3 col1, Vector3 col2, Vector3 col3) {
        this.m00 = col0.x;
        this.m10 = col1.x;
        this.m20 = col2.x;
        this.m30 = col3.x;
        this.m01 = col0.y;
        this.m11 = col1.y;
        this.m21 = col2.y;
        this.m31 = col3.y;
        this.m02 = col0.z;
        this.m12 = col1.z;
        this.m22 = col2.z;
        this.m32 = col3.z;
        this.m03 = 0.0;
        this.m13 = 0.0;
        this.m23 = 0.0;
        this.m33 = 0.0;
    }

    public Matrix44(Vector4 col0, Vector4 col1, Vector4 col2, Vector4 col3) {
        this.m00 = col0.x;
        this.m10 = col1.x;
        this.m20 = col2.x;
        this.m30 = col3.x;
        this.m01 = col0.y;
        this.m11 = col1.y;
        this.m21 = col2.y;
        this.m31 = col3.y;
        this.m02 = col0.z;
        this.m12 = col1.z;
        this.m22 = col2.z;
        this.m32 = col3.z;
        this.m03 = col0.w;
        this.m13 = col1.w;
        this.m23 = col2.w;
        this.m33 = col3.w;
    }

    public Matrix44 inverse() {
        double n00 = this.m12 * this.m23 * this.m31 - this.m13 * this.m22 * this.m31 + this.m13 * this.m21 * this.m32 - this.m11 * this.m23 * this.m32 - this.m12 * this.m21 * this.m33 + this.m11 * this.m22 * this.m33;
        double n01 = this.m03 * this.m22 * this.m31 - this.m02 * this.m23 * this.m31 - this.m03 * this.m21 * this.m32 + this.m01 * this.m23 * this.m32 + this.m02 * this.m21 * this.m33 - this.m01 * this.m22 * this.m33;
        double n02 = this.m02 * this.m13 * this.m31 - this.m03 * this.m12 * this.m31 + this.m03 * this.m11 * this.m32 - this.m01 * this.m13 * this.m32 - this.m02 * this.m11 * this.m33 + this.m01 * this.m12 * this.m33;
        double n03 = this.m03 * this.m12 * this.m21 - this.m02 * this.m13 * this.m21 - this.m03 * this.m11 * this.m22 + this.m01 * this.m13 * this.m22 + this.m02 * this.m11 * this.m23 - this.m01 * this.m12 * this.m23;
        double n10 = this.m13 * this.m22 * this.m30 - this.m12 * this.m23 * this.m30 - this.m13 * this.m20 * this.m32 + this.m10 * this.m23 * this.m32 + this.m12 * this.m20 * this.m33 - this.m10 * this.m22 * this.m33;
        double n11 = this.m02 * this.m23 * this.m30 - this.m03 * this.m22 * this.m30 + this.m03 * this.m20 * this.m32 - this.m00 * this.m23 * this.m32 - this.m02 * this.m20 * this.m33 + this.m00 * this.m22 * this.m33;
        double n12 = this.m03 * this.m12 * this.m30 - this.m02 * this.m13 * this.m30 - this.m03 * this.m10 * this.m32 + this.m00 * this.m13 * this.m32 + this.m02 * this.m10 * this.m33 - this.m00 * this.m12 * this.m33;
        double n13 = this.m02 * this.m13 * this.m20 - this.m03 * this.m12 * this.m20 + this.m03 * this.m10 * this.m22 - this.m00 * this.m13 * this.m22 - this.m02 * this.m10 * this.m23 + this.m00 * this.m12 * this.m23;
        double n20 = this.m11 * this.m23 * this.m30 - this.m13 * this.m21 * this.m30 + this.m13 * this.m20 * this.m31 - this.m10 * this.m23 * this.m31 - this.m11 * this.m20 * this.m33 + this.m10 * this.m21 * this.m33;
        double n21 = this.m03 * this.m21 * this.m30 - this.m01 * this.m23 * this.m30 - this.m03 * this.m20 * this.m31 + this.m00 * this.m23 * this.m31 + this.m01 * this.m20 * this.m33 - this.m00 * this.m21 * this.m33;
        double n22 = this.m01 * this.m13 * this.m30 - this.m03 * this.m11 * this.m30 + this.m03 * this.m10 * this.m31 - this.m00 * this.m13 * this.m31 - this.m01 * this.m10 * this.m33 + this.m00 * this.m11 * this.m33;
        double n23 = this.m03 * this.m11 * this.m20 - this.m01 * this.m13 * this.m20 - this.m03 * this.m10 * this.m21 + this.m00 * this.m13 * this.m21 + this.m01 * this.m10 * this.m23 - this.m00 * this.m11 * this.m23;
        double n30 = this.m12 * this.m21 * this.m30 - this.m11 * this.m22 * this.m30 - this.m12 * this.m20 * this.m31 + this.m10 * this.m22 * this.m31 + this.m11 * this.m20 * this.m32 - this.m10 * this.m21 * this.m32;
        double n31 = this.m01 * this.m22 * this.m30 - this.m02 * this.m21 * this.m30 + this.m02 * this.m20 * this.m31 - this.m00 * this.m22 * this.m31 - this.m01 * this.m20 * this.m32 + this.m00 * this.m21 * this.m32;
        double n32 = this.m02 * this.m11 * this.m30 - this.m01 * this.m12 * this.m30 - this.m02 * this.m10 * this.m31 + this.m00 * this.m12 * this.m31 + this.m01 * this.m10 * this.m32 - this.m00 * this.m11 * this.m32;
        double n33 = this.m01 * this.m12 * this.m20 - this.m02 * this.m11 * this.m20 + this.m02 * this.m10 * this.m21 - this.m00 * this.m12 * this.m21 - this.m01 * this.m10 * this.m22 + this.m00 * this.m11 * this.m22;
        double d = this.determinant();
        return new Matrix44(n00 / d, n10 / d, n20 / d, n30 / d, n01 / d, n11 / d, n21 / d, n31 / d, n02 / d, n12 / d, n22 / d, n32 / d, n03 / d, n13 / d, n23 / d, n33 / d);
    }

    public double determinant() {
        return this.m03 * this.m12 * this.m21 * this.m30 - this.m02 * this.m13 * this.m21 * this.m30 - this.m03 * this.m11 * this.m22 * this.m30 + this.m01 * this.m13 * this.m22 * this.m30 + this.m02 * this.m11 * this.m23 * this.m30 - this.m01 * this.m12 * this.m23 * this.m30 - this.m03 * this.m12 * this.m20 * this.m31 + this.m02 * this.m13 * this.m20 * this.m31 + this.m03 * this.m10 * this.m22 * this.m31 - this.m00 * this.m13 * this.m22 * this.m31 - this.m02 * this.m10 * this.m23 * this.m31 + this.m00 * this.m12 * this.m23 * this.m31 + this.m03 * this.m11 * this.m20 * this.m32 - this.m01 * this.m13 * this.m20 * this.m32 - this.m03 * this.m10 * this.m21 * this.m32 + this.m00 * this.m13 * this.m21 * this.m32 + this.m01 * this.m10 * this.m23 * this.m32 - this.m00 * this.m11 * this.m23 * this.m32 - this.m02 * this.m11 * this.m20 * this.m33 + this.m01 * this.m12 * this.m20 * this.m33 + this.m02 * this.m10 * this.m21 * this.m33 - this.m00 * this.m12 * this.m21 * this.m33 - this.m01 * this.m10 * this.m22 * this.m33 + this.m00 * this.m11 * this.m22 * this.m33;
    }

    public Matrix44(double x00, double x10, double x20, double x30, double x01, double x11, double x21, double x31, double x02, double x12, double x22, double x32, double x03, double x13, double x23, double x33) {
        this.m00 = x00;
        this.m01 = x01;
        this.m02 = x02;
        this.m03 = x03;
        this.m10 = x10;
        this.m11 = x11;
        this.m12 = x12;
        this.m13 = x13;
        this.m20 = x20;
        this.m21 = x21;
        this.m22 = x22;
        this.m23 = x23;
        this.m30 = x30;
        this.m31 = x31;
        this.m32 = x32;
        this.m33 = x33;
    }

    public Matrix44(double[] mat) {
        assert (mat.length >= 16) : "Invalid matrix array length";
        int i = 0;
        this.m00 = mat[i++];
        this.m01 = mat[i++];
        this.m02 = mat[i++];
        this.m03 = mat[i++];
        this.m10 = mat[i++];
        this.m11 = mat[i++];
        this.m12 = mat[i++];
        this.m13 = mat[i++];
        this.m20 = mat[i++];
        this.m21 = mat[i++];
        this.m22 = mat[i++];
        this.m23 = mat[i++];
        this.m30 = mat[i++];
        this.m31 = mat[i++];
        this.m32 = mat[i++];
        this.m33 = mat[i++];
    }

    public Matrix44(Matrix44 mat) {
        this.m00 = mat.m00;
        this.m01 = mat.m01;
        this.m02 = mat.m02;
        this.m03 = mat.m03;
        this.m10 = mat.m10;
        this.m11 = mat.m11;
        this.m12 = mat.m12;
        this.m13 = mat.m13;
        this.m20 = mat.m20;
        this.m21 = mat.m21;
        this.m22 = mat.m22;
        this.m23 = mat.m23;
        this.m30 = mat.m30;
        this.m31 = mat.m31;
        this.m32 = mat.m32;
        this.m33 = mat.m33;
    }

    public Vector4 getColumn(int columnIndex) {
        assert (columnIndex < 4) : "Invalid column index = " + columnIndex;
        switch (columnIndex) {
            case 0: {
                return new Vector4(this.m00, this.m01, this.m02, this.m03);
            }
            case 1: {
                return new Vector4(this.m10, this.m11, this.m12, this.m13);
            }
            case 2: {
                return new Vector4(this.m20, this.m21, this.m22, this.m23);
            }
            case 3: {
                return new Vector4(this.m30, this.m31, this.m32, this.m33);
            }
        }
        throw new IllegalArgumentException("Invalid column index = " + columnIndex);
    }

    public Matrix44 multiply(Matrix44 mat) {
        return new Matrix44(this.m00 * mat.m00 + this.m10 * mat.m01 + this.m20 * mat.m02 + this.m30 * mat.m03, this.m00 * mat.m10 + this.m10 * mat.m11 + this.m20 * mat.m12 + this.m30 * mat.m13, this.m00 * mat.m20 + this.m10 * mat.m21 + this.m20 * mat.m22 + this.m30 * mat.m23, this.m00 * mat.m30 + this.m10 * mat.m31 + this.m20 * mat.m32 + this.m30 * mat.m33, this.m01 * mat.m00 + this.m11 * mat.m01 + this.m21 * mat.m02 + this.m31 * mat.m03, this.m01 * mat.m10 + this.m11 * mat.m11 + this.m21 * mat.m12 + this.m31 * mat.m13, this.m01 * mat.m20 + this.m11 * mat.m21 + this.m21 * mat.m22 + this.m31 * mat.m23, this.m01 * mat.m30 + this.m11 * mat.m31 + this.m21 * mat.m32 + this.m31 * mat.m33, this.m02 * mat.m00 + this.m12 * mat.m01 + this.m22 * mat.m02 + this.m32 * mat.m03, this.m02 * mat.m10 + this.m12 * mat.m11 + this.m22 * mat.m12 + this.m32 * mat.m13, this.m02 * mat.m20 + this.m12 * mat.m21 + this.m22 * mat.m22 + this.m32 * mat.m23, this.m02 * mat.m30 + this.m12 * mat.m31 + this.m22 * mat.m32 + this.m32 * mat.m33, this.m03 * mat.m00 + this.m13 * mat.m01 + this.m23 * mat.m02 + this.m33 * mat.m03, this.m03 * mat.m10 + this.m13 * mat.m11 + this.m23 * mat.m12 + this.m33 * mat.m13, this.m03 * mat.m20 + this.m13 * mat.m21 + this.m23 * mat.m22 + this.m33 * mat.m23, this.m03 * mat.m30 + this.m13 * mat.m31 + this.m23 * mat.m32 + this.m33 * mat.m33);
    }

    public Matrix44 scale(double s) {
        return new Matrix44(s * this.m00, s * this.m10, s * this.m20, s * this.m30, s * this.m01, s * this.m11, s * this.m21, s * this.m31, s * this.m02, s * this.m12, s * this.m22, s * this.m32, s * this.m03, s * this.m13, s * this.m23, s * this.m33);
    }

    public double sum() {
        return this.m00 + this.m01 + this.m02 + this.m03 + this.m10 + this.m11 + this.m12 + this.m13 + this.m20 + this.m21 + this.m22 + this.m23 + this.m30 + this.m31 + this.m32 + this.m33;
    }

    public Matrix44 add(Matrix44 o) {
        return new Matrix44(this.m00 + o.m00, this.m10 + o.m10, this.m20 + o.m20, this.m30 + o.m30, this.m01 + o.m01, this.m11 + o.m11, this.m21 + o.m21, this.m31 + o.m31, this.m02 + o.m02, this.m12 + o.m12, this.m22 + o.m22, this.m32 + o.m32, this.m03 + o.m03, this.m13 + o.m13, this.m23 + o.m23, this.m33 + o.m33);
    }

    public Matrix44 subtract(Matrix44 o) {
        return new Matrix44(this.m00 - o.m00, this.m10 - o.m10, this.m20 - o.m20, this.m30 - o.m30, this.m01 - o.m01, this.m11 - o.m11, this.m21 - o.m21, this.m31 - o.m31, this.m02 - o.m02, this.m12 - o.m12, this.m22 - o.m22, this.m32 - o.m32, this.m03 - o.m03, this.m13 - o.m13, this.m23 - o.m23, this.m33 - o.m33);
    }

    public Matrix44 transpose() {
        return new Matrix44(this.m00, this.m01, this.m02, this.m03, this.m10, this.m11, this.m12, this.m13, this.m20, this.m21, this.m22, this.m23, this.m30, this.m31, this.m32, this.m33);
    }

    public Matrix44 toFloatBuffer(FloatBuffer fb) {
        fb.put((float)this.m00);
        fb.put((float)this.m01);
        fb.put((float)this.m02);
        fb.put((float)this.m03);
        fb.put((float)this.m10);
        fb.put((float)this.m11);
        fb.put((float)this.m12);
        fb.put((float)this.m13);
        fb.put((float)this.m20);
        fb.put((float)this.m21);
        fb.put((float)this.m22);
        fb.put((float)this.m23);
        fb.put((float)this.m30);
        fb.put((float)this.m31);
        fb.put((float)this.m32);
        fb.put((float)this.m33);
        return this;
    }

    public String toString() {
        return "Matrix44{m00=" + this.m00 + ", m10=" + this.m10 + ", m20=" + this.m20 + ", m30=" + this.m30 + "\n m01=" + this.m01 + ", m11=" + this.m11 + ", m21=" + this.m21 + ", m31=" + this.m31 + "\n m02=" + this.m02 + ", m12=" + this.m12 + ", m22=" + this.m22 + ", m32=" + this.m32 + "\n m03=" + this.m03 + ", m13=" + this.m13 + ", m23=" + this.m23 + ", m33=" + this.m33 + '}';
    }
}

