/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.math;

import net.lustlab.rndr.math.Vector3;

public class Matrix33 {
    public final double m00;
    public final double m10;
    public final double m20;
    public final double m01;
    public final double m11;
    public final double m21;
    public final double m02;
    public final double m12;
    public final double m22;

    public Matrix33() {
        this.m20 = 0.0;
        this.m10 = 0.0;
        this.m00 = 0.0;
        this.m21 = 0.0;
        this.m11 = 0.0;
        this.m01 = 0.0;
        this.m22 = 0.0;
        this.m12 = 0.0;
        this.m02 = 0.0;
    }

    public Matrix33(double x00, double x10, double x20, double x01, double x11, double x21, double x02, double x12, double x22) {
        this.m00 = x00;
        this.m10 = x10;
        this.m20 = x20;
        this.m01 = x01;
        this.m11 = x11;
        this.m21 = x21;
        this.m02 = x02;
        this.m12 = x12;
        this.m22 = x22;
    }

    public Matrix33(double diagonalValue) {
        this.m11 = this.m22 = diagonalValue;
        this.m00 = this.m22;
        this.m20 = 0.0;
        this.m10 = 0.0;
        this.m21 = 0.0;
        this.m01 = 0.0;
        this.m12 = 0.0;
        this.m02 = 0.0;
    }

    public Matrix33(double dv0, double dv1, double dv2) {
        this.m00 = dv0;
        this.m11 = dv1;
        this.m22 = dv2;
        this.m02 = 0.0;
        this.m01 = 0.0;
        this.m12 = 0.0;
        this.m10 = 0.0;
        this.m21 = 0.0;
        this.m20 = 0.0;
    }

    public Matrix33(Vector3 col0, Vector3 col1, Vector3 col2, Vector3 col3) {
        this.m00 = col0.x;
        this.m10 = col1.x;
        this.m20 = col2.x;
        this.m01 = col0.y;
        this.m11 = col1.y;
        this.m21 = col2.y;
        this.m02 = col0.z;
        this.m12 = col1.z;
        this.m22 = col2.z;
    }

    public double determinant() {
        return this.m00 * (this.m11 * this.m22 - this.m12 * this.m21) - this.m01 * (this.m10 * this.m22 - this.m12 * this.m20) + this.m02 * (this.m10 * this.m21 - this.m11 * this.m20);
    }

    public Matrix33 inverse() {
        double det = this.determinant();
        if (det != 0.0) {
            double idet = 1.0 / det;
            double d00 = (this.m11 * this.m22 - this.m12 * this.m21) * idet;
            double d10 = (this.m20 * this.m12 - this.m22 * this.m10) * idet;
            double d20 = (this.m10 * this.m21 - this.m11 * this.m20) * idet;
            double d01 = (this.m21 * this.m02 - this.m22 * this.m01) * idet;
            double d11 = (this.m00 * this.m22 - this.m02 * this.m20) * idet;
            double d21 = (this.m20 * this.m01 - this.m21 * this.m00) * idet;
            double d02 = (this.m01 * this.m12 - this.m02 * this.m11) * idet;
            double d12 = (this.m10 * this.m02 - this.m12 * this.m00) * idet;
            double d22 = (this.m00 * this.m11 - this.m01 * this.m10) * idet;
            return new Matrix33(d00, d10, d20, d01, d11, d21, d02, d12, d22);
        }
        throw new RuntimeException("determinant == 0");
    }

    public Matrix33 multiply(Matrix33 mat) {
        return new Matrix33(this.m00 * mat.m00 + this.m10 * mat.m01 + this.m20 * mat.m02, this.m00 * mat.m10 + this.m10 * mat.m11 + this.m20 * mat.m12, this.m00 * mat.m20 + this.m10 * mat.m21 + this.m20 * mat.m22, this.m01 * mat.m00 + this.m11 * mat.m01 + this.m21 * mat.m02, this.m01 * mat.m10 + this.m11 * mat.m11 + this.m21 * mat.m12, this.m01 * mat.m20 + this.m11 * mat.m21 + this.m21 * mat.m22, this.m02 * mat.m00 + this.m12 * mat.m01 + this.m22 * mat.m02, this.m02 * mat.m10 + this.m12 * mat.m11 + this.m22 * mat.m12, this.m02 * mat.m20 + this.m12 * mat.m21 + this.m22 * mat.m22);
    }

    public Matrix33 transpose() {
        return new Matrix33(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m20, this.m21, this.m22);
    }

    public String toString() {
        return "Matrix33{m00=" + this.m00 + ", m10=" + this.m10 + ", m20=" + this.m20 + "\nm01=" + this.m01 + ", m11=" + this.m11 + ", m21=" + this.m21 + "\nm02=" + this.m02 + ", m12=" + this.m12 + ", m22=" + this.m22 + '}';
    }
}

