/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.math;

public class Mapping {
    public static double map(double beforeLeft, double beforeRight, double afterLeft, double afterRight, double value) {
        double n = (value - beforeLeft) / (beforeRight - beforeLeft);
        return afterLeft + n * (afterRight - afterLeft);
    }

    public static double smoothstep(double edge0, double edge1, double x) {
        x = Mapping.saturate((x - edge0) / (edge1 - edge0));
        return x * x * (3.0 - 2.0 * x);
    }

    public static double smootherstep(double edge0, double edge1, double x) {
        x = Mapping.saturate((x - edge0) / (edge1 - edge0));
        return x * x * x * (x * (x * 6.0 - 15.0) + 10.0);
    }

    public static double saturate(double x) {
        return Math.max(0.0, Math.min(1.0, x));
    }
}

