/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.math;

import net.lustlab.rndr.math.Vector2;
import net.lustlab.rndr.math.Vector3;

public abstract class Bezier {
    public static double bezier(double x0, double c0, double x1, double t) {
        double it = 1.0 - t;
        double it2 = it * it;
        double t2 = t * t;
        return it2 * x0 + 2.0 * it * t * c0 + t2 * x1;
    }

    public static double derivative(double x0, double c0, double x1, double t) {
        double it = 1.0 - t;
        return 2.0 * it * (c0 - x0) + 2.0 * t * (x1 - c0);
    }

    public static Vector2 derivative(Vector2 x0, Vector2 c0, Vector2 x1, double t) {
        double it = 1.0 - t;
        return new Vector2(2.0 * it - (c0.x - x0.x) + 2.0 * t * (x1.x - c0.x), 2.0 * it - (c0.x - x0.x) + 2.0 * t * (x1.x - c0.x));
    }

    public static Vector2 normal(Vector2 x0, Vector2 c0, Vector2 x1, double t) {
        Vector2 d = Bezier.derivative(x0, c0, x1, t);
        return new Vector2(-d.y, d.x).normalized();
    }

    public static Vector2 bezier(Vector2 x0, Vector2 c0, Vector2 x1, double t) {
        double it = 1.0 - t;
        double it2 = it * it;
        double t2 = t * t;
        Vector2 result = new Vector2();
        result.x = it2 * x0.x + 2.0 * it * t * c0.x + t2 * x1.x;
        result.y = it2 * x0.y + 2.0 * it * t * c0.y + t2 * x1.y;
        return result;
    }

    public static Vector3 bezier(Vector3 x0, Vector3 c0, Vector3 x1, double t) {
        double it = 1.0 - t;
        double it2 = it * it;
        double t2 = t * t;
        Vector3 result = new Vector3();
        result.x = it2 * x0.x + 2.0 * it * t * c0.x + t2 * x1.x;
        result.y = it2 * x0.y + 2.0 * it * t * c0.y + t2 * x1.y;
        result.z = it2 * x0.z + 2.0 * it * t * c0.z + t2 * x1.z;
        return result;
    }

    public static double bezier(double x0, double c0, double c1, double x1, double t) {
        double it = 1.0 - t;
        double it2 = it * it;
        double it3 = it2 * it;
        double t2 = t * t;
        double t3 = t2 * t;
        return it3 * x0 + 3.0 * it2 * t * c0 + 3.0 * it * t2 * c1 + t3 * x1;
    }

    public static Vector2 bezier(Vector2 x0, Vector2 c0, Vector2 c1, Vector2 x1, double t) {
        double it = 1.0 - t;
        double it2 = it * it;
        double it3 = it2 * it;
        double t2 = t * t;
        double t3 = t2 * t;
        Vector2 result = new Vector2();
        result.x = it3 * x0.x + 3.0 * it2 * t * c0.x + 3.0 * it * t2 * c1.x + t3 * x1.x;
        result.y = it3 * x0.y + 3.0 * it2 * t * c0.y + 3.0 * it * t2 * c1.y + t3 * x1.y;
        return result;
    }

    public static Vector3 bezier(Vector3 x0, Vector3 c0, Vector3 c1, Vector3 x1, double t) {
        double it = 1.0 - t;
        double it2 = it * it;
        double it3 = it2 * it;
        double t2 = t * t;
        double t3 = t2 * t;
        Vector3 result = new Vector3();
        result.x = it3 * x0.x + 3.0 * it2 * t * c0.x + 3.0 * it * t2 * c1.x + t3 * x1.x;
        result.y = it3 * x0.y + 3.0 * it2 * t * c0.y + 3.0 * it * t2 * c1.y + t3 * x1.y;
        result.z = it3 * x0.z + 3.0 * it2 * t * c0.z + 3.0 * it * t2 * c1.z + t3 * x1.z;
        return result;
    }
}

