/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.image;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GL3;
import net.lustlab.rndr.gl.GLError;

public class BufferTexture {
    int buffer;
    int texture;
    GL3 gl3;

    public static BufferTexture createStatic(GL3 gl3, ByteBuffer buffer, int size, int format) {
        int[] buffers = new int[1];
        gl3.glGenBuffers(1, buffers, 0);
        gl3.glBindBuffer(35882, buffers[0]);
        gl3.glBufferData(35882, (long)buffer.remaining(), (Buffer)buffer, 35044);
        int[] textures = new int[1];
        gl3.glGenTextures(1, textures, 0);
        gl3.glBindTexture(35882, textures[0]);
        gl3.glTexBuffer(35882, format, buffers[0]);
        gl3.glBindBuffer(35882, 0);
        return new BufferTexture(gl3, buffers[0], textures[0]);
    }

    public static BufferTexture createStream(GL3 gl3, ByteBuffer buffer, int size, int format) {
        int[] buffers = new int[1];
        gl3.glGenBuffers(1, buffers, 0);
        gl3.glBindBuffer(35882, buffers[0]);
        gl3.glBufferData(35882, (long)buffer.remaining(), (Buffer)buffer, 35040);
        int[] textures = new int[1];
        gl3.glGenTextures(1, textures, 0);
        gl3.glBindTexture(35882, textures[0]);
        gl3.glTexBuffer(35882, format, buffers[0]);
        gl3.glBindBuffer(35882, 0);
        return new BufferTexture(gl3, buffers[0], textures[0]);
    }

    public BufferTexture write(GL3 gl3, ByteBuffer input) {
        gl3.glBindBuffer(35882, this.buffer);
        GLError.check((GL)gl3);
        gl3.glBufferSubData(35882, 0L, (long)input.remaining(), (Buffer)input);
        GLError.check((GL)gl3);
        gl3.glBindBuffer(35882, 0);
        GLError.check((GL)gl3);
        return this;
    }

    public BufferTexture replace(GL3 gl3, ByteBuffer input) {
        gl3.glBindBuffer(35882, this.buffer);
        GLError.check((GL)gl3);
        gl3.glBufferData(35882, 0L, null, 35040);
        GLError.check((GL)gl3);
        gl3.glBufferData(35882, (long)input.remaining(), (Buffer)input, 35040);
        GLError.check((GL)gl3);
        gl3.glBindBuffer(35882, 0);
        GLError.check((GL)gl3);
        return this;
    }

    BufferTexture(GL3 gl3, int buffer, int texture) {
        this.buffer = buffer;
        this.texture = texture;
        this.gl3 = gl3;
    }

    public void bindTexture() {
        this.gl3.glBindTexture(35882, this.texture);
    }

    public void unbindTexture() {
        this.gl3.glBindTexture(35882, 0);
    }
}

