/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.font.vector;

import com.itextpdf.awt.DefaultFontMapper;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.pdf.BaseFont;
import java.awt.FontFormatException;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import net.lustlab.rndr.RNDRException;
import net.lustlab.rndr.color.Color;
import net.lustlab.rndr.draw.Batch;
import net.lustlab.rndr.draw.Composition;
import net.lustlab.rndr.draw.Contour;
import net.lustlab.rndr.draw.Segment;
import net.lustlab.rndr.math.Vector2;

public class GlyphExtractor {
    public Composition extractGlyphFromFont(String fontName, int size, String text) {
        FontFactory.registerDirectories();
        Font _font = FontFactory.getFont((String)fontName);
        if (_font == null) {
            throw new RuntimeException("font not found: " + fontName);
        }
        BaseFont baseFont = _font.getBaseFont();
        if (baseFont == null) {
            throw new RuntimeException("font not found: " + fontName);
        }
        DefaultFontMapper dfm = new DefaultFontMapper();
        java.awt.Font font = dfm.pdfToAwt(baseFont, size);
        return this.extractGlyph(font, size, text);
    }

    public Composition extractGlyphFromFile(String fontfile, int size, String text) {
        java.awt.Font font = null;
        try {
            font = java.awt.Font.createFont(0, new File(fontfile));
            return this.extractGlyph(font, size, text);
        }
        catch (FontFormatException | IOException e) {
            throw new RNDRException(e);
        }
    }

    public Composition extractGlyph(java.awt.Font font, int size, String text) {
        Composition composition = new Composition();
        FontRenderContext frc = new FontRenderContext(AffineTransform.getTranslateInstance(0.0, 0.0), false, true);
        GlyphVector gv = font.createGlyphVector(frc, text);
        double[] coords = new double[6];
        ArrayList<net.lustlab.rndr.draw.Shape> shapes = new ArrayList<net.lustlab.rndr.draw.Shape>();
        Vector2 cursor = new Vector2();
        Vector2 anchor = new Vector2(0.0, 0.0);
        for (int g = 0; g < gv.getNumGlyphs(); ++g) {
            Shape glyph = gv.getGlyphOutline(g);
            net.lustlab.rndr.draw.Shape activeShape = new net.lustlab.rndr.draw.Shape();
            Contour activeContour = null;
            PathIterator pathIterator = glyph.getPathIterator(null);
            while (!pathIterator.isDone()) {
                int type = pathIterator.currentSegment(coords);
                switch (type) {
                    case 0: {
                        if (activeContour != null) {
                            activeShape.contours.add(activeContour);
                        }
                        activeContour = new Contour();
                        cursor.x = coords[0];
                        cursor.y = coords[1];
                        anchor.x = coords[0];
                        anchor.y = coords[1];
                        break;
                    }
                    case 1: {
                        activeContour.segments.add(new Segment(cursor.copy(), new Vector2(coords[0], coords[1])));
                        cursor.x = coords[0];
                        cursor.y = coords[1];
                        break;
                    }
                    case 4: {
                        activeContour.segments.add(new Segment(cursor.copy(), anchor.copy()));
                        activeContour.closed = true;
                        break;
                    }
                    case 2: {
                        activeContour.segments.add(new Segment(cursor.copy(), new Vector2(coords[0], coords[1]), new Vector2(coords[2], coords[3])));
                        cursor.x = coords[2];
                        cursor.y = coords[3];
                        break;
                    }
                    case 3: {
                        activeContour.segments.add(new Segment(cursor.copy(), new Vector2(coords[0], coords[1]), new Vector2(coords[2], coords[3]), new Vector2(coords[4], coords[5])));
                        cursor.x = coords[4];
                        cursor.y = coords[5];
                        break;
                    }
                    default: {
                        throw new RuntimeException("unsupported command");
                    }
                }
                pathIterator.next();
                if (!pathIterator.isDone()) continue;
                activeShape.contours.add(activeContour);
                break;
            }
            activeShape.fill = Color.WHITE;
            shapes.add(activeShape);
            Batch batch = (Batch)composition.root;
            batch.nodes.add(activeShape);
        }
        return composition;
    }
}

