/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.font.vector;

import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL;
import javax.media.opengl.GL3;
import net.lustlab.rndr.color.Color;
import net.lustlab.rndr.draw.Rectangle;
import net.lustlab.rndr.font.FontMap;
import net.lustlab.rndr.font.FontMapRenderer;
import net.lustlab.rndr.font.vector.FontVectorMap;
import net.lustlab.rndr.math.Matrix44;
import net.lustlab.rndr.math.Transforms;
import net.lustlab.rndr.math.Vector3;
import net.lustlab.rndr.shaders.FragmentShader;
import net.lustlab.rndr.shaders.Shader;
import net.lustlab.rndr.shaders.VertexShader;
import net.lustlab.rndr.vbo.VAO;

public class FontVectorMapRendererGL3
implements FontMapRenderer {
    public Color fill = Color.WHITE;
    public Color stroke = null;
    private Rectangle clipRectangle = null;
    private static Shader shader;

    @Override
    public double width(FontMap fontMap, String text) {
        FontVectorMap fontVectorMap = (FontVectorMap)fontMap;
        double width = 0.0;
        for (char c : text.toCharArray()) {
            FontVectorMap.Entry entity = fontVectorMap.characters.get(Character.valueOf(c));
            if (entity == null) continue;
            width += entity.width;
        }
        return width;
    }

    @Override
    public List<FontMapRenderer.CharacterRectangle> render(GL gl, FontMap fontMap, String text, double x, double y) {
        return null;
    }

    @Override
    public List<FontMapRenderer.CharacterRectangle> render(GL gl, FontMap fontMap, String text, double x, double y, double tracking) {
        return null;
    }

    @Override
    public List<FontMapRenderer.CharacterRectangle> render(GL3 gl, Matrix44 projection, Matrix44 modelView, FontMap fontMap, String text, double x, double y) {
        return this.render(gl, projection, modelView, fontMap, text, x, y, 0.0);
    }

    @Override
    public List<FontMapRenderer.CharacterRectangle> render(GL3 gl, Matrix44 projection, Matrix44 modelView, FontMap fontMap, String text, double x, double y, double tracking) {
        gl.glEnable(3042);
        gl.glBlendFunc(770, 771);
        gl.glEnable(2848);
        if (shader == null) {
            shader = Shader.createShader((GL)gl, VertexShader.load((GL)gl, this.getClass().getResourceAsStream("/shaders/gl3/vectorfont.vert")), FragmentShader.load((GL)gl, this.getClass().getResourceAsStream("/shaders/gl3/vectorfont.frag")));
        }
        FontVectorMap map = (FontVectorMap)fontMap;
        if (map.vao == null) {
            map.bakeVBO(gl, shader);
        }
        map.vao.bind();
        shader.begin();
        if (this.clipRectangle != null) {
            shader.setUniform4f("clipArea", (float)this.clipRectangle.x, (float)(this.clipRectangle.x + this.clipRectangle.width), (float)this.clipRectangle.y, (float)(this.clipRectangle.y + this.clipRectangle.height));
            int[] viewport = new int[4];
            gl.glGetIntegerv(2978, viewport, 0);
            shader.setUniform1f("viewHeight", viewport[3]);
        }
        shader.setUniform("color", this.fill);
        ArrayList<FontMapRenderer.CharacterRectangle> result = new ArrayList<FontMapRenderer.CharacterRectangle>();
        double cursorX = x;
        for (char c : text.toCharArray()) {
            FontVectorMap.Entry entry;
            if (c == '\u00a0') {
                c = ' ';
            }
            if ((entry = map.characters.get(Character.valueOf(c))) == null) continue;
            Matrix44 transform = modelView.multiply(Transforms.translate(new Vector3(cursorX, y, 0.0)));
            Matrix44 modelViewProjection = projection.multiply(transform);
            for (FontVectorMap.VBORange range : entry.ranges) {
                shader.setUniform("modelViewProjectionMatrix", modelViewProjection.transpose());
                gl.glDrawArrays((int)range.command, (int)range.offset, (int)range.vertices);
            }
            FontMapRenderer.CharacterRectangle characterRectangle = new FontMapRenderer.CharacterRectangle(c, cursorX, y, entry.width, map.fontHeight());
            result.add(characterRectangle);
            cursorX += entry.width + tracking;
        }
        shader.end();
        VAO.defaultInstance.bind();
        return result;
    }

    @Override
    public void clip(double left, double top, double width, double height) {
        this.clipRectangle = left == 0.0 && top == 0.0 && (float)width == Float.POSITIVE_INFINITY && (float)height == Float.POSITIVE_INFINITY ? null : new Rectangle(left, top, width, height);
    }

    @Override
    public void noClip() {
        this.clipRectangle = null;
    }

    @Override
    public void fill(Color color) {
        this.fill = new Color(color);
    }

    @Override
    public void noFill() {
        this.fill = null;
    }

    @Override
    public void stroke(Color color) {
        this.stroke = color != null ? new Color(color) : null;
    }

    @Override
    public void noStroke() {
        this.stroke = null;
    }
}

