/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.font.image;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL;
import javax.media.opengl.GL3;
import net.lustlab.rndr.color.Color;
import net.lustlab.rndr.draw.Rectangle;
import net.lustlab.rndr.font.FontMap;
import net.lustlab.rndr.font.FontMapRenderer;
import net.lustlab.rndr.font.image.FontImageMap;
import net.lustlab.rndr.font.image.FontImageMapBuilder;
import net.lustlab.rndr.math.Matrix44;
import net.lustlab.rndr.math.Vector2;
import net.lustlab.rndr.math.Vector3;
import net.lustlab.rndr.shaders.FragmentShader;
import net.lustlab.rndr.shaders.Shader;
import net.lustlab.rndr.shaders.VertexShader;
import net.lustlab.rndr.vbo.BufferWriter;
import net.lustlab.rndr.vbo.VBO;
import net.lustlab.rndr.vbo.VBODrawer;
import net.lustlab.rndr.vbo.VBOLayout;

public class FontImageMapRendererGL3
implements FontMapRenderer {
    static Shader shader = null;
    static VBO vbo = null;
    static VBOLayout layout = new VBOLayout().textureCoordinate(2).position(3);
    static ByteBuffer buffer;
    static final int bufferSize;
    static BufferWriter bufferWriter;
    public double clipLeft = -1.0;
    public double clipRight = 32768.0;
    public double clipTop = -1.0;
    public double clipBottom = 32768.0;
    public Color fill = Color.WHITE;
    private Rectangle clipRectangle;
    public int vertexCount = 0;
    public VerticalPositioning verticalPositioning = VerticalPositioning.Baseline;

    public FontImageMapRendererGL3(GL gl) {
        if (shader == null) {
            shader = Shader.createShader(gl, VertexShader.load(gl, FontImageMapRendererGL3.class.getResourceAsStream("/shaders/gl3/font.vert")), FragmentShader.load(gl, FontImageMapRendererGL3.class.getResourceAsStream("/shaders/gl3/font.frag")));
        }
        if (vbo == null) {
            buffer = ByteBuffer.allocateDirect(bufferSize);
            bufferWriter = new BufferWriter(buffer);
            vbo = VBO.createDynamicVBO(gl, buffer, bufferSize);
        }
    }

    @Override
    public List<FontMapRenderer.CharacterRectangle> render(GL gl, FontMap fontImageMap, String text, double x, double y) {
        return null;
    }

    @Override
    public List<FontMapRenderer.CharacterRectangle> render(GL gl, FontMap fontMap, String text, double x, double y, double tracking) {
        return null;
    }

    @Override
    public List<FontMapRenderer.CharacterRectangle> render(GL3 gl, Matrix44 projection, Matrix44 modelView, FontMap fontMap, String text, double x, double y) {
        return this.render(gl, projection, modelView, fontMap, text, x, y, 0.0);
    }

    @Override
    public List<FontMapRenderer.CharacterRectangle> render(GL3 gl, Matrix44 projection, Matrix44 modelView, FontMap fontMap, String text, double x, double y, double tracking) {
        buffer.rewind();
        shader.begin();
        shader.setUniform("modelViewProjectionMatrix", projection.multiply(modelView).transpose());
        ArrayList<FontMapRenderer.CharacterRectangle> result = new ArrayList<FontMapRenderer.CharacterRectangle>();
        FontImageMap fontImageMap = (FontImageMap)fontMap;
        if (text != null && this.fill != null) {
            shader.setUniform("fill", this.fill);
            double clipLeft = -1.0;
            double clipRight = 32768.0;
            double clipTop = -1.0;
            double clipBottom = 32768.0;
            if (this.clipRectangle != null) {
                clipLeft = this.clipRectangle.x;
                clipTop = this.clipRectangle.y;
                clipRight = clipLeft + this.clipRectangle.width;
                clipBottom = clipTop + this.clipRectangle.height;
            }
            shader.setUniform4f("clipArea", (float)clipLeft, (float)clipRight, (float)clipTop, (float)clipBottom);
            int[] viewport = new int[4];
            gl.glGetIntegerv(2978, viewport, 0);
            shader.setUniform1f("viewHeight", viewport[3]);
            shader.setUniform1i("image", 0);
            gl.glActiveTexture(33984);
            fontImageMap.getTexture().bind((GL)gl);
            gl.glGenerateMipmap(3553);
            gl.glTexParameteri(3553, 10241, 9729);
            gl.glTexParameteri(3553, 10240, 9729);
            gl.glEnable(3042);
            gl.glBlendFunc(1, 771);
            float xoff = 0.0f;
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (c == '\u00a0') {
                    c = ' ';
                }
                if (i != 0) {
                    char left = text.charAt(i - 1);
                    xoff += fontImageMap.kerning(left, c);
                }
                if (i != 0) {
                    xoff = (float)((double)xoff + tracking);
                }
                if (fontImageMap.getMap().get(Character.valueOf(c)) == null) continue;
                result.add(new FontMapRenderer.CharacterRectangle(c, x + (double)((int)xoff), y, fontImageMap.getMap().get((Object)Character.valueOf((char)c)).getArea().width, fontMap.fontHeight()));
                this.renderCharacterQuad(fontImageMap, c, x + (double)((int)xoff), y);
                xoff += fontImageMap.characterWidth(c);
            }
            this.renderCharacters(gl);
            gl.glBlendFunc(1, 771);
            gl.glDisable(3042);
            shader.end();
        }
        return result;
    }

    @Override
    public void clip(double left, double right, double width, double height) {
        this.clipRectangle = new Rectangle(left, right, width, height);
    }

    @Override
    public void noClip() {
        this.clipRectangle = null;
    }

    @Override
    public void fill(Color color) {
        this.fill = new Color(color);
    }

    @Override
    public void noFill() {
        this.fill = null;
    }

    @Override
    public void stroke(Color color) {
    }

    @Override
    public void noStroke() {
    }

    @Override
    public double width(FontMap fontMap, String text) {
        FontImageMap fontImageMap = (FontImageMap)fontMap;
        double width = 0.0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (i != 0) {
                char left = text.charAt(i - 1);
                width += (double)fontImageMap.kerning(left, c);
            }
            width += (double)fontImageMap.characterWidth(c);
        }
        return width;
    }

    public void render(GL3 gl, FontImageMap fontImageMap, char character, int x, int y) {
        fontImageMap.getTexture().enable((GL)gl);
        fontImageMap.getTexture().bind((GL)gl);
        gl.glEnable(3042);
        gl.glBlendFunc(1, 771);
        buffer.rewind();
        this.vertexCount = 0;
        this.renderCharacterQuad(fontImageMap, character, x, y);
        this.renderCharacters(gl);
        gl.glDisable(3042);
        fontImageMap.getTexture().disable((GL)gl);
    }

    void renderCharacters(GL3 gl3) {
        buffer.rewind();
        vbo.write(buffer, 0, this.vertexCount * layout.size());
        vbo.bind();
        VBODrawer.draw((GL)gl3, shader, vbo, layout, 4, this.vertexCount);
        vbo.unbind();
        this.vertexCount = 0;
        buffer.rewind();
    }

    private void renderCharacterQuad(FontImageMap fontImageMap, char character, double x, double y) {
        BufferWriter bw = bufferWriter;
        float s = fontImageMap.getSanding();
        float packSize = fontImageMap.getTexture().getHeight();
        if (fontImageMap.getMap().get(Character.valueOf(character)) != null) {
            double characterWidth = fontImageMap.getMap().get((Object)Character.valueOf((char)character)).getArea().width - 2.0f * s;
            double characterHeight = fontImageMap.getMap().get((Object)Character.valueOf((char)character)).getArea().height - 2.0f * s;
            double u0 = (fontImageMap.getMap().get((Object)Character.valueOf((char)character)).getArea().topLeft.x + s) / packSize;
            double v0 = (fontImageMap.getMap().get((Object)Character.valueOf((char)character)).getArea().topLeft.y + s) / packSize;
            double u1 = u0 + characterWidth / (double)packSize;
            double v1 = v0 + characterHeight / (double)packSize;
            FontImageMapBuilder.Entry e = (FontImageMapBuilder.Entry)fontImageMap.getMap().get(Character.valueOf(character)).getData();
            float xo = (float)e.pixelBounds.getMinX();
            float yo = (float)e.pixelBounds.getMinY();
            if (this.verticalPositioning == VerticalPositioning.Height) {
                yo += (float)fontImageMap.fontHeight;
            }
            bw.write(new Vector2(u0, v0));
            bw.write(new Vector3(x + (double)xo, y + (double)yo, 0.0));
            bw.write(new Vector2(u1, v0));
            bw.write(new Vector3(x + characterWidth + (double)xo, y + (double)yo, 0.0));
            bw.write(new Vector2(u1, v1));
            bw.write(new Vector3(x + characterWidth + (double)xo, y + characterHeight + (double)yo, 0.0));
            bw.write(new Vector2(u0, v0));
            bw.write(new Vector3(x + (double)xo, y + (double)yo, 0.0));
            bw.write(new Vector2(u0, v1));
            bw.write(new Vector3(x + (double)xo, y + characterHeight + (double)yo, 0.0));
            bw.write(new Vector2(u1, v1));
            bw.write(new Vector3(x + characterWidth + (double)xo, y + characterHeight + (double)yo, 0.0));
            this.vertexCount += 6;
        }
    }

    static {
        bufferSize = 18 * layout.size() * 256;
    }

    public static enum VerticalPositioning {
        Baseline,
        Height;

    }
}

