/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.font.image;

import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureIO;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import net.lustlab.rndr.RNDRException;
import net.lustlab.rndr.font.FontDescriptor;
import net.lustlab.rndr.font.image.FontImageMap;
import net.lustlab.rndr.font.image.FontImageMapBuilder;
import net.lustlab.rndr.font.image.FontImageMapIO;

public class FontImageMapManager {
    static Logger logger = Logger.getLogger(FontImageMapManager.class.getName());
    private static Map<FontDescriptor, FontImageMap> fontMaps = new HashMap<FontDescriptor, FontImageMap>();

    public static FontImageMap fontMap(String font, int size) {
        return FontImageMapManager.fontMap(new FontDescriptor(font, size));
    }

    public static FontImageMap fontMap(FontDescriptor descriptor) {
        FontImageMap fontImageMap = fontMaps.get(descriptor);
        if (fontImageMap == null) {
            File file = new File("font-cache/");
            if (!file.exists()) {
                file.mkdir();
            }
            String basename = "font-cache/" + descriptor.name.replace("/", "_") + "@" + descriptor.size;
            File cachedFile = new File(basename + ".ifm");
            File cachedImageFile = new File(basename + ".png");
            if (cachedFile.exists() && cachedImageFile.exists()) {
                logger.info("loading font from cache");
                FontImageMap temp = FontImageMapIO.load(basename + ".ifm");
                Texture texture = null;
                try {
                    texture = TextureIO.newTexture((File)new File(basename + ".png"), (boolean)false);
                    fontImageMap = new FontImageMap(temp, texture);
                }
                catch (IOException e) {
                    throw new RNDRException(e);
                }
            } else {
                fontImageMap = !descriptor.name.endsWith(".ttf") ? FontImageMapBuilder.buildFontMap(descriptor.name, descriptor.size) : FontImageMapBuilder.buildFontMapFromFile(descriptor.name, descriptor.size);
                logger.info("done caching font");
            }
            fontMaps.put(descriptor, fontImageMap);
        }
        return fontImageMap;
    }
}

