/*
 * Decompiled with CFR 0.152.
 */
package net.lustlab.rndr.font.image;

import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.awt.AWTTextureIO;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.media.opengl.GLProfile;
import net.lustlab.packer.AsIsOrderer;
import net.lustlab.packer.BinarySplitter;
import net.lustlab.packer.Orderer;
import net.lustlab.packer.PackNode;
import net.lustlab.packer.Packer;
import net.lustlab.packer.Rectangle;
import net.lustlab.packer.Splitter;
import net.lustlab.rndr.font.EntityPairIndex;
import net.lustlab.rndr.font.FontDescriptor;
import net.lustlab.rndr.font.FontResolver;
import net.lustlab.rndr.font.image.FontImageMap;

public class FontImageMapBuilder {
    private static Logger logger = Logger.getLogger(FontImageMapBuilder.class.getName());
    public static final char[] alphabet = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00eb', '\u00e4', '\u00f6', '\u00fc', '\u00ef', '\u00ff', '\u00cb', '\u00c4', '\u00d6', '\u00dc', '\u00cf', '\u0178', '\u00f1', '\u00d1', '\u00e7', '\u00c7', '\u00f8', '\u00d8', '\u00e9', '\u00e1', '\u00f3', '\u00ed', '\u00fa', '\u00c9', '\u00c1', '\u00d3', '\u00cd', '\u00da', '\u00e8', '\u00e0', '\u00f2', '\u00ec', '\u00f9', '\u00c8', '\u00c0', '\u00d2', '\u00cc', '\u00d9', '\u00e2', '\u00ea', '\u00ee', '\u00fb', '\u00f4', '\u00c2', '\u00ca', '\u00ce', '\u00db', '\u00d4', '\u0153', '\u0152', '\u00e6', '\u00c6', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '!', '?', '\u00bf', '\u00a1', '\u2026', '.', ',', ' ', ':', ';', '&', '#', '\u2116', '\u201c', '\u201d', '\u2018', '\u2019', '`', '\u00a4', '\u20ac', '$', '\u00a3', '\u2012', '-', '\u2014', '\u2013', '_', '\u00b7', '\u2022', '\u00b0', '@', '^', '*', '\u00ab', '\u00bb', '/', '\\', '\"', '\'', '+', '=', '\u00f7', '~', '%', '(', ')', '[', ']', '{', '}', '<', '>'};

    public static FontImageMap buildFontMapFromFile(String filename, int size) {
        int format = 0;
        String[] type1Extensions = new String[]{".pfb", ".pfm", ".afm", ".ofm", ".pfa"};
        if (filename.endsWith(".ttf") || filename.endsWith(".otf")) {
            format = 0;
        } else {
            for (String extension : type1Extensions) {
                if (!filename.endsWith(extension)) continue;
                format = 1;
            }
        }
        File fontFile = new File(filename);
        if (fontFile.exists()) {
            try {
                Font font = Font.createFont(format, fontFile).deriveFont((float)size);
                return FontImageMapBuilder.buildFontMap(filename, size, font);
            }
            catch (FontFormatException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            logger.severe("font file not found: " + filename);
            return null;
        }
        return null;
    }

    public static FontImageMap buildFontMap(String fontName, int size) {
        return FontImageMapBuilder.buildFontMap(fontName, size, FontResolver.resolveSystemFont(fontName, size));
    }

    private static FontImageMap buildFontMap(String fontName, int size, Font font) {
        HashMap<EntityPairIndex, Float> kerningPairs = new HashMap<EntityPairIndex, Float>();
        int sanding = 4;
        int packSize = 256;
        BufferedImage offImg = null;
        Graphics2D graphics = null;
        FontMetrics metrics = null;
        Packer packer = new Packer((Orderer)new AsIsOrderer(), (Splitter)new BinarySplitter(), null);
        PackNode root = null;
        while (true) {
            offImg = new BufferedImage(packSize, packSize, 2);
            graphics = offImg.createGraphics();
            graphics.setFont(font);
            metrics = graphics.getFontMetrics();
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            root = new PackNode(new Rectangle(0.0f, 0.0f, (float)packSize, (float)packSize));
            if (FontImageMapBuilder.attemptPack(root, packer, graphics, font, metrics, 4)) break;
            logger.info("failed, pack size set to : " + (packSize *= 2));
        }
        logger.info("pack size set to : " + packSize);
        root = new PackNode(new Rectangle(0.0f, 0.0f, (float)packSize, (float)packSize));
        graphics.clearRect(0, 0, packSize, packSize);
        HashMap<Character, PackNode> packMap = new HashMap<Character, PackNode>();
        WritableRaster raster = offImg.getRaster();
        for (int j = 0; j < packSize; ++j) {
            for (int i = 0; i < packSize; ++i) {
                raster.setPixel(j, i, new int[]{0, 0, 0, 0});
            }
        }
        List<Entry> entries = FontImageMapBuilder.getSortedEntries(graphics, font, metrics);
        for (Entry entry : entries) {
            PackNode dest = packer.insert(root, new Rectangle(0.0f, 0.0f, (float)((int)entry.pixelBounds.getWidth() + 8), (float)((int)entry.pixelBounds.getHeight() + 8)));
            dest.setData((Object)entry);
            FontRenderContext frc = new FontRenderContext(AffineTransform.getTranslateInstance(0.0, 0.0), true, true);
            if (dest == null) continue;
            logger.finest(entry.entity + " " + dest.getArea().width + " " + dest.getArea().height);
            packMap.put(Character.valueOf(entry.entity), dest);
            entry.width = metrics.stringWidth("" + entry.entity);
            graphics.drawRect((int)dest.getArea().topLeft.x, (int)dest.getArea().topLeft.y, (int)dest.getArea().width, (int)dest.getArea().height);
            if (font.canDisplay(entry.entity)) {
                GlyphVector g = font.createGlyphVector(metrics.getFontRenderContext(), "" + entry.entity);
                double mx = entry.pixelBounds.getMinX();
                double my = entry.pixelBounds.getMinY();
                graphics.drawGlyphVector(g, (int)((double)dest.getArea().topLeft.x - mx + 4.0), (int)((double)dest.getArea().topLeft.y - my + 4.0));
                continue;
            }
            logger.warning("font cannot display: " + entry.entity);
        }
        System.out.println("making texture");
        Texture texture = AWTTextureIO.newTexture((GLProfile)GLProfile.getGL2GL3(), (BufferedImage)offImg, (boolean)false);
        int fontHeight = metrics.getMaxAscent() + metrics.getMaxDescent();
        return new FontImageMap(new FontDescriptor(fontName, size), texture, packMap, kerningPairs, 4, fontHeight, size, metrics.getLeading());
    }

    private static boolean attemptPack(PackNode root, Packer packer, Graphics2D graphics, Font font, FontMetrics metrics, int sanding) {
        boolean success = true;
        List<Entry> entries = FontImageMapBuilder.getSortedEntries(graphics, font, metrics);
        for (Entry entry : entries) {
            int head = metrics.getMaxAscent() / 4;
            int ascent = metrics.getMaxAscent();
            int descent = metrics.getMaxDescent();
            PackNode dest = packer.insert(root, new Rectangle(0.0f, 0.0f, (float)((int)entry.pixelBounds.getWidth() + 2 * sanding), (float)((int)entry.pixelBounds.getHeight() + 2 * sanding + head)));
            if (dest != null) continue;
            success = false;
            break;
        }
        return success;
    }

    private static List<Entry> getSortedEntries(Graphics2D graphics, Font font, FontMetrics metrics) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        AffineTransform at = AffineTransform.getTranslateInstance(0.0, 0.0);
        FontRenderContext frc = new FontRenderContext(at, true, true);
        for (char entity : alphabet) {
            Entry entry = new Entry();
            graphics.setFont(font);
            GlyphVector glyph = font.createGlyphVector(frc, "" + entity);
            java.awt.Rectangle pixelBounds = glyph.getPixelBounds(frc, 0.0f, 0.0f);
            entry.entity = entity;
            entry.pixelBounds = pixelBounds;
            entries.add(entry);
        }
        Collections.sort(entries, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                double a2;
                double a1 = o1.pixelBounds.getWidth() * o1.pixelBounds.getHeight();
                if (a1 < (a2 = o2.pixelBounds.getWidth() * o2.pixelBounds.getHeight())) {
                    return 1;
                }
                if (a1 > a2) {
                    return -1;
                }
                return 0;
            }
        });
        return entries;
    }

    public static class Entry
    implements Serializable {
        char entity;
        public Rectangle2D pixelBounds;
        public int width;
    }
}

